package net.kafujo.samples.wikidata.parser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class WikidataParser <T> {

    protected final Logger lgr = LoggerFactory.getLogger(IntParser.class);

    protected final Map<String, Integer> fallbackCounter = new HashMap<>();

    public Map<String, Integer> getFallbackCounter() {
        return Collections.unmodifiableMap(fallbackCounter);
    }

    public abstract T parse (final String raw);

    public abstract T parseFbk (final String raw, final T fbk);
}
