package net.kafujo.samples.wikidata.parser;

import net.kafujo.base.UncheckedException;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class UrlParser extends WikidataParser<URL> {

    public static final UrlParser DEFAULT = new UrlParser();

    @Override
    public URL parseFbk(final String raw, URL fbk) {
        try {
            return parse(raw);
        } catch (Exception any) {
            lgr.debug("could not get URL from '{}': {}", raw, any.toString());
            fallbackCounter.merge(raw, 1, Integer::sum);
        }
        return fbk;
    }

    @Override
    public URL parse(final String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse URL");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse URL");
        }
        String clean = raw.strip();
        try {
            return new URL(clean);
        } catch (MalformedURLException fail) {
            throw new UncheckedException("Problem parsing URL from " + clean, fail);
        }
    }
}
