package net.kafujo.samples.wikidata.parser;

import net.kafujo.units.Location;

public class LocationParser extends WikidataParser<Location> {

    public static final LocationParser DEFAULT = new LocationParser();

    @Override
    public Location parseFbk(final String raw, Location fbk) {
        try {
            return parse(raw);
        } catch (Exception any) {
            lgr.debug("could not get Location from '{}': {}", raw, any.toString());
            fallbackCounter.merge(raw, 1, Integer::sum);
        }
        return fbk;
    }

    @Override
    public Location parse(final String raw) {
        return Location.ofPoint(raw);
    }
}
