package net.kafujo.samples.wikidata.parser;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Objects;

public class LocalDateParser extends WikidataParser<LocalDate> {

    public static final LocalDateParser DEFAULT = new LocalDateParser();

    @Override
    public LocalDate parseFbk(final String raw, LocalDate fbk) {
        try {
            return parse(raw);
        } catch (Exception any) {
            lgr.debug("could not get LocalDate from '{}': {}", raw, any.toString());
            fallbackCounter.merge(raw, 1, Integer::sum);
        }
        return fbk;
    }

    @Override
    public LocalDate parse(final String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse date");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse date");
        }
        String clean = raw.strip();
        return LocalDate.ofInstant(Instant.parse(clean), ZoneId.systemDefault());
    }
}
