package net.kafujo.samples;

import java.awt.*;
import java.io.Serializable;
import java.util.List;

public class Vegetable implements Serializable {

    public static final Vegetable TOMATOE = new Vegetable("tomatoe", "tomatoes", Color.RED);
    public static final Vegetable CUCUMBER = new Vegetable("cucumber", "cucumbers", Color.GREEN);
    public static final Vegetable POTATOE = new Vegetable("potato", "pataoes", Color.YELLOW);
    public static final Vegetable PUMPKIN = new Vegetable("pumpkin", "pumpkins", Color.ORANGE);
    public static final Vegetable CAULIFLOWER = new Vegetable("cauliflower", "cauliflowers", Color.WHITE);
    public static final Vegetable CARROT = new Vegetable("carrot", "carrots", Color.RED);
    public static final Vegetable RADSIH = new Vegetable("radish", "radishes", Color.RED);

    public final static List<Vegetable> LIST = List.of(TOMATOE, CUCUMBER, POTATOE, PUMPKIN, CAULIFLOWER, CARROT, RADSIH);

    private final String name;
    private final String plural;
    private final Color color;

    public Vegetable(String name, String plural, Color color) {
        this.name = name;
        this.plural = plural;
        this.color = color;
    }

    public String getName() {
        return name;
    }

    public String getPlural() {
        return plural;
    }

    public Color getColor() {
        return color;
    }

    @Override
    public String toString() {
        return "Vegetable '" + name + "'";
    }
}
