package net.kafujo.samples;

import net.kafujo.io.KafuResource;
import net.kafujo.units.DataSize;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class DigitalStorageDevices {

    public static final String DEVICES_CSV = "data_storage_devices.csv";
    public static final List<DigitalStorageDevices> LIST;

    private final DataSize capacity;
    private final String name;

    static {
        var list = new LinkedList<DigitalStorageDevices>();

        for (String line : KafuResource.asLines(DEVICES_CSV)) {
            String[] split = line.split(",");
            list.add(new DigitalStorageDevices(split[0], DataSize.of(split[1])));
        }
        LIST = Collections.unmodifiableList(list);

    }

    public DigitalStorageDevices(final String name, final DataSize capacity) {
        this.capacity = capacity;
        this.name = Objects.requireNonNull(name);
    }

    public DataSize getCapacity() {
        return capacity;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return name + " -> " + capacity;
    }
}
