/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.samples;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.kafujo.io.Resources;
import net.kafujo.units.DataSize;

public class DigitalStorageDevices {
    public static final String DEVICES_CSV = "data_storage_devices.csv";
    public static final List<DigitalStorageDevices> LIST;
    private final DataSize capacity;
    private final String name;

    public DigitalStorageDevices(String name, DataSize capacity) {
        this.capacity = capacity;
        this.name = Objects.requireNonNull(name);
    }

    public DataSize getCapacity() {
        return this.capacity;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " -> " + this.capacity;
    }

    static {
        LinkedList<DigitalStorageDevices> list = new LinkedList<DigitalStorageDevices>();
        for (String line : Resources.asLines((String)DEVICES_CSV)) {
            String[] split = line.split(",");
            list.add(new DigitalStorageDevices(split[0], DataSize.of((String)split[1])));
        }
        LIST = Collections.unmodifiableList(list);
    }
}

