/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Arrays;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public abstract class ComparableSpecification<T>
extends PathSpecification<T> {
    private String comparedTo;
    private Converter converter;

    public ComparableSpecification(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("expected one http-param, but was " + Arrays.toString(httpParamValues));
        }
        this.comparedTo = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Path rootPath = this.path(root);
        Class typeOnPath = rootPath.getJavaType();
        return this.makePredicate(cb, (Expression)rootPath, (Comparable)((Comparable)this.converter.convert(this.comparedTo, typeOnPath)));
    }

    protected abstract <Y extends Comparable<? super Y>> Predicate makePredicate(CriteriaBuilder var1, Expression<? extends Y> var2, Y var3);
}

