/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web.annotation;

import java.util.List;
import net.kaczmarzyk.spring.data.jpa.domain.EmptyResultOnTypeMismatch;
import net.kaczmarzyk.spring.data.jpa.domain.WithoutTypeConversion;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import org.springframework.data.jpa.domain.Specification;

public enum OnTypeMismatch {
    EXCEPTION{

        @Override
        public <T> Specification<T> wrap(Specification<T> spec) {
            return spec;
        }

        @Override
        void doHandleRejectedValues(List<String> rejected) {
            throw new Converter.ValuesRejectedException(rejected, "invalid values present in the HTTP param");
        }
    }
    ,
    EMPTY_RESULT{

        @Override
        public <T> Specification<T> wrap(Specification<T> spec) {
            if (spec instanceof WithoutTypeConversion) {
                return spec;
            }
            return new EmptyResultOnTypeMismatch<T>(spec);
        }

        @Override
        void doHandleRejectedValues(List<String> rejected) {
        }
    }
    ,
    DEFAULT{

        @Override
        public <T> Specification<T> wrap(Specification<T> spec) {
            return EMPTY_RESULT.wrap(spec);
        }

        @Override
        void doHandleRejectedValues(List<String> rejected) {
            EMPTY_RESULT.doHandleRejectedValues(rejected);
        }
    };


    public abstract <T> Specification<T> wrap(Specification<T> var1);

    public void handleRejectedValues(List<String> rejected) {
        if (rejected != null && !rejected.isEmpty()) {
            this.doHandleRejectedValues(rejected);
        }
    }

    abstract void doHandleRejectedValues(List<String> var1);
}

