/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.tls;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import net.jradius.tls.Certificate;
import net.jradius.tls.CertificateVerifyer;
import net.jradius.tls.SecurityParameters;
import net.jradius.tls.TlsDSSSigner;
import net.jradius.tls.TlsKeyExchange;
import net.jradius.tls.TlsProtocolHandler;
import net.jradius.tls.TlsRSASigner;
import net.jradius.tls.TlsSigner;
import net.jradius.tls.TlsUtils;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.io.SignerInputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.util.BigIntegers;

class TlsDHKeyExchange
implements TlsKeyExchange {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private TlsProtocolHandler handler;
    private CertificateVerifyer verifyer;
    private short keyExchange;
    private TlsSigner tlsSigner;
    private AsymmetricKeyParameter serverPublicKey = null;
    private DHPublicKeyParameters dhAgreeServerPublicKey = null;
    private AsymmetricCipherKeyPair dhAgreeClientKeyPair = null;

    TlsDHKeyExchange(TlsProtocolHandler handler, CertificateVerifyer verifyer, short keyExchange) {
        switch (keyExchange) {
            case 7: 
            case 8: {
                this.tlsSigner = null;
                break;
            }
            case 5: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 3: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.handler = handler;
        this.verifyer = verifyer;
        this.keyExchange = keyExchange;
    }

    public void skipServerCertificate() throws IOException {
        this.handler.failWithError((short)2, (short)10);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        X509CertificateStructure x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey((SubjectPublicKeyInfo)keyInfo);
        }
        catch (RuntimeException e) {
            this.handler.failWithError((short)2, (short)43);
        }
        if (this.serverPublicKey.isPrivate()) {
            this.handler.failWithError((short)2, (short)80);
        }
        switch (this.keyExchange) {
            case 7: {
                if (!(this.serverPublicKey instanceof DHPublicKeyParameters)) {
                    this.handler.failWithError((short)2, (short)46);
                }
                this.dhAgreeServerPublicKey = this.validateDHPublicKey((DHPublicKeyParameters)this.serverPublicKey);
                break;
            }
            case 8: {
                if (!(this.serverPublicKey instanceof DHPublicKeyParameters)) {
                    this.handler.failWithError((short)2, (short)46);
                }
                this.dhAgreeServerPublicKey = this.validateDHPublicKey((DHPublicKeyParameters)this.serverPublicKey);
                break;
            }
            case 5: {
                if (!(this.serverPublicKey instanceof RSAKeyParameters)) {
                    this.handler.failWithError((short)2, (short)46);
                }
                this.validateKeyUsage(x509Cert, 128);
                break;
            }
            case 3: {
                if (this.serverPublicKey instanceof DSAPublicKeyParameters) break;
                this.handler.failWithError((short)2, (short)46);
                break;
            }
            default: {
                this.handler.failWithError((short)2, (short)43);
            }
        }
        if (!this.verifyer.isValid(serverCertificate.getCerts())) {
            this.handler.failWithError((short)2, (short)90);
        }
    }

    public void skipServerKeyExchange() throws IOException {
        if (this.tlsSigner != null) {
            this.handler.failWithError((short)2, (short)10);
        }
    }

    public void processServerKeyExchange(InputStream is, SecurityParameters securityParameters) throws IOException {
        byte[] sigByte;
        if (this.tlsSigner == null) {
            this.handler.failWithError((short)2, (short)10);
        }
        InputStream sigIn = is;
        Signer signer = null;
        if (this.tlsSigner != null) {
            signer = this.initSigner(this.tlsSigner, securityParameters);
            sigIn = new SignerInputStream(is, signer);
        }
        byte[] pBytes = TlsUtils.readOpaque16(sigIn);
        byte[] gBytes = TlsUtils.readOpaque16(sigIn);
        byte[] YsBytes = TlsUtils.readOpaque16(sigIn);
        if (signer != null && !signer.verifySignature(sigByte = TlsUtils.readOpaque16(is))) {
            this.handler.failWithError((short)2, (short)42);
        }
        BigInteger p = new BigInteger(1, pBytes);
        BigInteger g = new BigInteger(1, gBytes);
        BigInteger Ys = new BigInteger(1, YsBytes);
        this.dhAgreeServerPublicKey = this.validateDHPublicKey(new DHPublicKeyParameters(Ys, new DHParameters(p, g)));
    }

    public byte[] generateClientKeyExchange() throws IOException {
        DHBasicKeyPairGenerator dhGen = new DHBasicKeyPairGenerator();
        dhGen.init((KeyGenerationParameters)new DHKeyGenerationParameters(this.handler.getRandom(), this.dhAgreeServerPublicKey.getParameters()));
        this.dhAgreeClientKeyPair = dhGen.generateKeyPair();
        BigInteger Yc = ((DHPublicKeyParameters)this.dhAgreeClientKeyPair.getPublic()).getY();
        return BigIntegers.asUnsignedByteArray((BigInteger)Yc);
    }

    public byte[] generatePremasterSecret() throws IOException {
        DHBasicAgreement dhAgree = new DHBasicAgreement();
        dhAgree.init(this.dhAgreeClientKeyPair.getPrivate());
        BigInteger agreement = dhAgree.calculateAgreement((CipherParameters)this.dhAgreeServerPublicKey);
        return BigIntegers.asUnsignedByteArray((BigInteger)agreement);
    }

    private void validateKeyUsage(X509CertificateStructure c, int keyUsageBits) throws IOException {
        DERBitString ku;
        int bits;
        X509Extension ext;
        X509Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(X509Extensions.KeyUsage)) != null && ((bits = (ku = KeyUsage.getInstance((Object)ext)).getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            this.handler.failWithError((short)2, (short)46);
        }
    }

    private Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }

    private DHPublicKeyParameters validateDHPublicKey(DHPublicKeyParameters key) throws IOException {
        BigInteger Y = key.getY();
        DHParameters params = key.getParameters();
        BigInteger p = params.getP();
        BigInteger g = params.getG();
        if (!p.isProbablePrime(2)) {
            this.handler.failWithError((short)2, (short)47);
        }
        if (g.compareTo(TWO) < 0 || g.compareTo(p.subtract(TWO)) > 0) {
            this.handler.failWithError((short)2, (short)47);
        }
        if (Y.compareTo(TWO) < 0 || Y.compareTo(p.subtract(ONE)) > 0) {
            this.handler.failWithError((short)2, (short)47);
        }
        return key;
    }
}

