/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.radsec;

import java.net.InetAddress;
import net.jradius.client.RadiusClient;
import net.jradius.handler.PacketHandlerBase;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.server.JRadiusRequest;
import org.springframework.beans.factory.InitializingBean;

public class SimpleProxyHandler
extends PacketHandlerBase
implements InitializingBean {
    private RadiusClient radiusClient;
    private String radiusServer = "localhost";
    private String sharedSecret = "testing123";
    private Integer authPort = 1812;
    private Integer acctPort = 1813;

    public boolean handle(JRadiusRequest request) throws Exception {
        RadiusRequest req = (RadiusRequest)request.getRequestPacket();
        RadiusResponse res = this.radiusClient.sendReceive(req, 3);
        request.setReplyPacket((RadiusPacket)res);
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        this.radiusClient = new RadiusClient(InetAddress.getByName(this.radiusServer), this.sharedSecret, this.authPort.intValue(), this.acctPort.intValue(), 60);
        if (this.radiusClient == null) {
            throw new RuntimeException("could not create RadSec proxy radius client");
        }
    }

    public void setRadiusClient(RadiusClient radiusClient) {
        this.radiusClient = radiusClient;
    }

    public void setRadiusServer(String radiusServer) {
        this.radiusServer = radiusServer;
    }

    public void setAuthPort(Integer authPort) {
        this.authPort = authPort;
    }

    public void setAcctPort(Integer acctPort) {
        this.acctPort = acctPort;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }
}

