/**
 * JRadius - A RADIUS Server Java Adapter
 * Copyright (C) 2004-2005 PicoPoint, B.V.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package net.jradius.server.event;

import net.jradius.server.JRadiusRequest;

/**
 * The Handler Log Event Type.
 * @author David Bird
 */
public class HandlerLogEvent extends ServerEvent
{
	private static final long serialVersionUID = 1L;
	private int result;
    
    public HandlerLogEvent(JRadiusRequest request, String sessionKey, int result)
    {
        setSender(request.getSender());
        setRequest(request);
        setSessionKey(sessionKey);
        this.result = result;
    }
    
    public String getTypeString()
    {
        return "handler-log";
    }
    
    public int getResult()
    {
        return result;
    }
}
