/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.4.0")
public interface LocalDateArbitrary
extends Arbitrary<LocalDate> {
    default public LocalDateArbitrary between(LocalDate min, LocalDate max) {
        if (min.isAfter(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public LocalDateArbitrary atTheEarliest(LocalDate var1);

    public LocalDateArbitrary atTheLatest(LocalDate var1);

    public LocalDateArbitrary yearBetween(Year var1, Year var2);

    default public LocalDateArbitrary yearBetween(int min, int max) {
        return this.yearBetween(Year.of(min), Year.of(max));
    }

    public LocalDateArbitrary monthBetween(Month var1, Month var2);

    default public LocalDateArbitrary monthBetween(int min, int max) {
        return this.monthBetween(Month.of(min), Month.of(max));
    }

    public LocalDateArbitrary onlyMonths(Month ... var1);

    public LocalDateArbitrary dayOfMonthBetween(int var1, int var2);

    public LocalDateArbitrary onlyDaysOfWeek(DayOfWeek ... var1);
}

