/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.MonthDayArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.YearMonthArbitrary;
import net.jqwik.time.api.arbitraries.ZonedDateTimeArbitrary;
import net.jqwik.time.api.constraints.MonthRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultCalendarArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultInstantArbitrary;

public class MonthRangeConfigurator {
    private static boolean filter(Month month, Month min, Month max) {
        return month.compareTo(min) >= 0 && month.compareTo(max) <= 0;
    }

    private static boolean filter(LocalDateTime dateTime, Month min, Month max) {
        return MonthRangeConfigurator.filter(dateTime.getMonth(), min, max);
    }

    private static boolean filter(Instant instant, Month min, Month max) {
        if (LocalDateTime.MIN.toInstant(ZoneOffset.UTC).isAfter(instant) || LocalDateTime.MAX.toInstant(ZoneOffset.UTC).isBefore(instant)) {
            return false;
        }
        return MonthRangeConfigurator.filter(DefaultInstantArbitrary.instantToLocalDateTime(instant), min, max);
    }

    private static boolean filter(OffsetDateTime dateTime, Month min, Month max) {
        return MonthRangeConfigurator.filter(dateTime.getMonth(), min, max);
    }

    private static boolean filter(ZonedDateTime dateTime, Month min, Month max) {
        return MonthRangeConfigurator.filter(dateTime.getMonth(), min, max);
    }

    private static boolean filter(LocalDate date, Month min, Month max) {
        return MonthRangeConfigurator.filter(date.getMonth(), min, max);
    }

    private static boolean filter(Calendar date, Month min, Month max) {
        Month month = DefaultCalendarArbitrary.calendarMonthToMonth(date);
        return MonthRangeConfigurator.filter(month, min, max);
    }

    private static boolean filter(Date date, Month min, Month max) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return MonthRangeConfigurator.filter(calendar, min, max);
    }

    private static boolean filter(YearMonth yearMonth, Month min, Month max) {
        return MonthRangeConfigurator.filter(yearMonth.getMonth(), min, max);
    }

    private static boolean filter(MonthDay monthDay, Month min, Month max) {
        return MonthRangeConfigurator.filter(monthDay.getMonth(), min, max);
    }

    public static class ForMonthDay
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(MonthDay.class);
        }

        public Arbitrary<MonthDay> configure(Arbitrary<MonthDay> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof MonthDayArbitrary) {
                MonthDayArbitrary monthDayArbitrary = (MonthDayArbitrary)arbitrary;
                return monthDayArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForYearMonth
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(YearMonth.class);
        }

        public Arbitrary<YearMonth> configure(Arbitrary<YearMonth> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof YearMonthArbitrary) {
                YearMonthArbitrary yearMonthArbitrary = (YearMonthArbitrary)arbitrary;
                return yearMonthArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForZonedDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(ZonedDateTime.class);
        }

        public Arbitrary<ZonedDateTime> configure(Arbitrary<ZonedDateTime> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof ZonedDateTimeArbitrary) {
                ZonedDateTimeArbitrary zonedDateTimeArbitrary = (ZonedDateTimeArbitrary)arbitrary;
                return zonedDateTimeArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForInstant
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Instant.class);
        }

        public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof InstantArbitrary) {
                InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
                return instantArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }
}

