/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.arbitraries.ZonedDateTimeArbitrary;
import net.jqwik.time.api.constraints.HourRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultInstantArbitrary;

public class HourRangeConfigurator {
    private static boolean filter(LocalTime time, int min, int max) {
        return time.getHour() >= min && time.getHour() <= max;
    }

    private static boolean filter(LocalDateTime dateTime, int min, int max) {
        return HourRangeConfigurator.filter(dateTime.toLocalTime(), min, max);
    }

    private static boolean filter(Instant instant, int min, int max) {
        if (LocalDateTime.MIN.toInstant(ZoneOffset.UTC).isAfter(instant) || LocalDateTime.MAX.toInstant(ZoneOffset.UTC).isBefore(instant)) {
            return false;
        }
        return HourRangeConfigurator.filter(DefaultInstantArbitrary.instantToLocalDateTime(instant).toLocalTime(), min, max);
    }

    private static boolean filter(OffsetDateTime dateTime, int min, int max) {
        return HourRangeConfigurator.filter(dateTime.toLocalTime(), min, max);
    }

    private static boolean filter(ZonedDateTime dateTime, int min, int max) {
        return HourRangeConfigurator.filter(dateTime.toLocalTime(), min, max);
    }

    private static boolean filter(OffsetTime offsetTime, int min, int max) {
        return HourRangeConfigurator.filter(offsetTime.toLocalTime(), min, max);
    }

    public static class ForOffsetTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetTime.class);
        }

        public Arbitrary<OffsetTime> configure(Arbitrary<OffsetTime> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof OffsetTimeArbitrary) {
                OffsetTimeArbitrary offsetTimeArbitrary = (OffsetTimeArbitrary)arbitrary;
                return offsetTimeArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalTime.class);
        }

        public Arbitrary<LocalTime> configure(Arbitrary<LocalTime> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof LocalTimeArbitrary) {
                LocalTimeArbitrary localTimeArbitrary = (LocalTimeArbitrary)arbitrary;
                return localTimeArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForZonedDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(ZonedDateTime.class);
        }

        public Arbitrary<ZonedDateTime> configure(Arbitrary<ZonedDateTime> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof ZonedDateTimeArbitrary) {
                ZonedDateTimeArbitrary zonedDateTimeArbitrary = (ZonedDateTimeArbitrary)arbitrary;
                return zonedDateTimeArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForInstant
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Instant.class);
        }

        public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof InstantArbitrary) {
                InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
                return instantArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }
}

