/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.6.3")
public interface ZonedDateTimeArbitrary
extends Arbitrary<ZonedDateTime> {
    default public ZonedDateTimeArbitrary between(LocalDateTime min, LocalDateTime max) {
        if (min.isAfter(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public ZonedDateTimeArbitrary atTheEarliest(LocalDateTime var1);

    public ZonedDateTimeArbitrary atTheLatest(LocalDateTime var1);

    public ZonedDateTimeArbitrary dateBetween(LocalDate var1, LocalDate var2);

    public ZonedDateTimeArbitrary yearBetween(Year var1, Year var2);

    default public ZonedDateTimeArbitrary yearBetween(int min, int max) {
        return this.yearBetween(Year.of(min), Year.of(max));
    }

    public ZonedDateTimeArbitrary monthBetween(Month var1, Month var2);

    default public ZonedDateTimeArbitrary monthBetween(int min, int max) {
        return this.monthBetween(Month.of(min), Month.of(max));
    }

    public ZonedDateTimeArbitrary onlyMonths(Month ... var1);

    public ZonedDateTimeArbitrary dayOfMonthBetween(int var1, int var2);

    public ZonedDateTimeArbitrary onlyDaysOfWeek(DayOfWeek ... var1);

    public ZonedDateTimeArbitrary timeBetween(LocalTime var1, LocalTime var2);

    public ZonedDateTimeArbitrary hourBetween(int var1, int var2);

    public ZonedDateTimeArbitrary minuteBetween(int var1, int var2);

    public ZonedDateTimeArbitrary secondBetween(int var1, int var2);

    public ZonedDateTimeArbitrary ofPrecision(ChronoUnit var1);
}

