/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.5.1")
public interface LocalTimeArbitrary
extends Arbitrary<LocalTime> {
    default public LocalTimeArbitrary between(LocalTime min, LocalTime max) {
        if (min.isAfter(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public LocalTimeArbitrary atTheEarliest(LocalTime var1);

    public LocalTimeArbitrary atTheLatest(LocalTime var1);

    public LocalTimeArbitrary hourBetween(int var1, int var2);

    public LocalTimeArbitrary minuteBetween(int var1, int var2);

    public LocalTimeArbitrary secondBetween(int var1, int var2);

    public LocalTimeArbitrary ofPrecision(ChronoUnit var1);
}

