/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.AllowedDayOfWeeks;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.AllowedMonths;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.DayOfMonthBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.LocalDateBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.MonthBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.YearBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultLocalDateArbitrary
extends ArbitraryDecorator<LocalDate>
implements LocalDateArbitrary {
    public static final LocalDate DEFAULT_MIN_DATE = LocalDate.of(1900, 1, 1);
    public static final LocalDate DEFAULT_MAX_DATE = LocalDate.of(2500, 12, 31);
    private final LocalDateBetween dateBetween = new LocalDateBetween();
    private final DayOfMonthBetween dayOfMonthBetween = new DayOfMonthBetween();
    private final AllowedMonths allowedMonths = new AllowedMonths();
    private final AllowedDayOfWeeks allowedDayOfWeeks = new AllowedDayOfWeeks();

    protected Arbitrary<LocalDate> arbitrary() {
        LocalDate effectiveMin = this.effectiveMinDate();
        LocalDate effectiveMax = this.effectiveMaxDate(effectiveMin);
        this.checkIfValuesArePossible(effectiveMin, effectiveMax);
        long days = ChronoUnit.DAYS.between(effectiveMin, effectiveMax);
        Arbitrary day = ((LongArbitrary)Arbitraries.longs().between(0L, days).withDistribution(RandomDistribution.uniform())).edgeCases(edgeCases -> {
            edgeCases.includeOnly((Object[])new Long[]{0L, days});
            Optional<Long> optionalLeapDay = this.firstLeapDayAfter(effectiveMin, days);
            optionalLeapDay.ifPresent(xva$0 -> edgeCases.add((Object[])new Long[]{xva$0}));
        });
        Arbitrary localDates = day.map(effectiveMin::plusDays);
        if (this.allowedMonths.get().size() < 12) {
            localDates = localDates.filter(date -> this.allowedMonths.get().contains(date.getMonth()));
        }
        if (this.allowedDayOfWeeks.get().size() < 7) {
            localDates = localDates.filter(date -> this.allowedDayOfWeeks.get().contains(date.getDayOfWeek()));
        }
        if (this.dayOfMonthBetween.getMax() != null && this.dayOfMonthBetween.getMin() != null && (Integer)this.dayOfMonthBetween.getMax() - (Integer)this.dayOfMonthBetween.getMin() != 30) {
            localDates = localDates.filter(date -> date.getDayOfMonth() >= (Integer)this.dayOfMonthBetween.getMin() && date.getDayOfMonth() <= (Integer)this.dayOfMonthBetween.getMax());
        }
        return localDates;
    }

    private void checkIfValuesArePossible(LocalDate min, LocalDate max) {
        if (max.getYear() - 2 >= min.getYear()) {
            if (this.valuesArePossible()) {
                return;
            }
        } else {
            int minDayOfMonth = this.dayOfMonthBetween.getMin() == null ? 1 : (Integer)this.dayOfMonthBetween.getMin();
            int maxDayOfMonth = this.dayOfMonthBetween.getMax() == null ? 31 : (Integer)this.dayOfMonthBetween.getMax();
            LocalDate date = min;
            while (!date.isAfter(max)) {
                if (minDayOfMonth <= date.getDayOfMonth() && maxDayOfMonth >= date.getDayOfMonth() && this.allowedMonths.get().contains(date.getMonth())) {
                    return;
                }
                date = date.plusDays(1L);
            }
        }
        throw new IllegalArgumentException("These min/max configurations cannot be used together: No values are possible.");
    }

    private boolean valuesArePossible() {
        int min = this.dayOfMonthBetween.getMin() == null ? 1 : (Integer)this.dayOfMonthBetween.getMin();
        return !(min == 31 && !this.allowedMonthContainsMonthWith31Days() || min == 30 && !this.allowedMonthContainsNotOnlyFebruary() || min == 29 && !this.allowedMonthContainsNotOnlyFebruary() && !DefaultLocalDateArbitrary.leapYearPossible(((LocalDate)this.dateBetween.getMin()).getYear(), ((LocalDate)this.dateBetween.getMax()).getYear()));
    }

    private boolean allowedMonthContainsMonthWith31Days() {
        Set allowed = this.allowedMonths.get();
        return allowed.contains(Month.JANUARY) || allowed.contains(Month.MARCH) || allowed.contains(Month.MAY) || allowed.contains(Month.JULY) || allowed.contains(Month.AUGUST) || allowed.contains(Month.OCTOBER) || allowed.contains(Month.DECEMBER);
    }

    private boolean allowedMonthContainsNotOnlyFebruary() {
        Set allowed = this.allowedMonths.get();
        return allowed.contains(Month.JANUARY) || allowed.contains(Month.MARCH) || allowed.contains(Month.APRIL) || allowed.contains(Month.MAY) || allowed.contains(Month.JUNE) || allowed.contains(Month.JULY) || allowed.contains(Month.AUGUST) || allowed.contains(Month.SEPTEMBER) || allowed.contains(Month.OCTOBER) || allowed.contains(Month.NOVEMBER) || allowed.contains(Month.DECEMBER);
    }

    public static boolean leapYearPossible(int min, int max) {
        if (max - min >= 8) {
            return true;
        }
        for (int y = min; y <= max; ++y) {
            if (!DefaultLocalDateArbitrary.isLeapYear(y)) continue;
            return true;
        }
        return false;
    }

    private LocalDate effectiveMaxDate(LocalDate effectiveMin) {
        LocalDate effective = this.dateBetween.getMax() == null ? DEFAULT_MAX_DATE : (LocalDate)this.dateBetween.getMax();
        int earliestMonth = this.earliestAllowedMonth();
        int latestMonth = this.latestAllowedMonth();
        if (earliestMonth > effective.getMonth().getValue()) {
            effective = effective.withMonth(12).withDayOfMonth(31).minusYears(1L);
        }
        if (latestMonth < effective.getMonth().getValue()) {
            effective = effective.withMonth(latestMonth + 1);
            effective = effective.minusDays(effective.getDayOfMonth());
        }
        if (this.dayOfMonthBetween.getMax() != null && (Integer)this.dayOfMonthBetween.getMax() < effective.getDayOfMonth()) {
            effective = effective.withDayOfMonth((Integer)this.dayOfMonthBetween.getMax());
        }
        if (effectiveMin.isAfter(effective)) {
            throw new IllegalArgumentException("These min/max configurations cannot be used together: No values are possible.");
        }
        return effective;
    }

    private int latestAllowedMonth() {
        return this.allowedMonths.get().stream().sorted((m1, m2) -> -Integer.compare(m1.getValue(), m2.getValue())).map(Month::getValue).findFirst().orElse(12);
    }

    private LocalDate effectiveMinDate() {
        LocalDate effective = this.dateBetween.getMin() == null ? DEFAULT_MIN_DATE : (LocalDate)this.dateBetween.getMin();
        int earliestMonth = this.earliestAllowedMonth();
        int latestMonth = this.latestAllowedMonth();
        if (latestMonth < effective.getMonth().getValue()) {
            effective = effective.withDayOfMonth(1).withMonth(1).plusYears(1L);
        }
        if (earliestMonth > effective.getMonth().getValue()) {
            effective = effective.withDayOfMonth(1).withMonth(earliestMonth);
        }
        if (this.dayOfMonthBetween.getMin() != null && (Integer)this.dayOfMonthBetween.getMin() > effective.getDayOfMonth()) {
            try {
                effective = effective.withDayOfMonth((Integer)this.dayOfMonthBetween.getMin());
            }
            catch (DateTimeException e) {
                effective = effective.plusMonths(1L).withDayOfMonth((Integer)this.dayOfMonthBetween.getMin());
            }
        }
        return effective;
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    private int earliestAllowedMonth() {
        return this.allowedMonths.get().stream().sorted(Comparator.comparing(Month::getValue)).map(Month::getValue).findFirst().orElse(1);
    }

    private Optional<Long> firstLeapDayAfter(LocalDate date, long maxOffset) {
        long offset = this.nextLeapDayOffset(date, 0L);
        if (offset > maxOffset) {
            return Optional.empty();
        }
        return Optional.of(offset);
    }

    private long nextLeapDayOffset(LocalDate date, long base) {
        if (date.isLeapYear() && date.getMonth().compareTo(Month.FEBRUARY) <= 0) {
            LocalDate leapDaySameYear = date.withMonth(2).withDayOfMonth(29);
            long offset = ChronoUnit.DAYS.between(date, leapDaySameYear);
            return base + offset;
        }
        int nextYear = date.getYear() + 1;
        if (nextYear > 999999999) {
            return Long.MAX_VALUE;
        }
        LocalDate nextJan1 = LocalDate.of(nextYear, 1, 1);
        return this.nextLeapDayOffset(nextJan1, base + ChronoUnit.DAYS.between(date, nextJan1));
    }

    @Override
    public LocalDateArbitrary atTheEarliest(LocalDate min) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.dateBetween.set(min, null);
        return clone;
    }

    @Override
    public LocalDateArbitrary atTheLatest(LocalDate max) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.dateBetween.set(null, max);
        return clone;
    }

    @Override
    public LocalDateArbitrary yearBetween(Year min, Year max) {
        YearBetween yearBetween = (YearBetween)new YearBetween().set(min, max);
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.dateBetween.setYearBetween(yearBetween);
        return clone;
    }

    @Override
    public LocalDateArbitrary monthBetween(Month min, Month max) {
        MonthBetween monthBetween = (MonthBetween)new MonthBetween().set(min, max);
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.allowedMonths.set(monthBetween);
        return clone;
    }

    @Override
    public LocalDateArbitrary onlyMonths(Month ... months) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.allowedMonths.set(months);
        return clone;
    }

    @Override
    public LocalDateArbitrary dayOfMonthBetween(int min, int max) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.dayOfMonthBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalDateArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultLocalDateArbitrary clone = (DefaultLocalDateArbitrary)this.typedClone();
        clone.allowedDayOfWeeks.set(daysOfWeek);
        return clone;
    }
}

