/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.ZoneOffset;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.time.api.arbitraries.ZoneOffsetArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.ZoneOffsetBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultZoneOffsetArbitrary
extends ArbitraryDecorator<ZoneOffset>
implements ZoneOffsetArbitrary {
    public static final ZoneOffset DEFAULT_MIN = ZoneOffset.ofHoursMinutesSeconds(14, 0, 0);
    public static final ZoneOffset DEFAULT_MAX = ZoneOffset.ofHoursMinutesSeconds(-12, 0, 0);
    private final ZoneOffsetBetween zoneOffsetBetween = new ZoneOffsetBetween();

    protected Arbitrary<ZoneOffset> arbitrary() {
        ZoneOffset effectiveMax;
        ZoneOffset effectiveMin = this.effectiveMin();
        if (effectiveMin.compareTo(effectiveMax = this.effectiveMax()) > 0) {
            throw new IllegalArgumentException("With this configuration is no value possible.");
        }
        int maxInt = this.indexOf(effectiveMin);
        int minInt = this.indexOf(effectiveMax);
        Arbitrary indexes = ((IntegerArbitrary)Arbitraries.integers().withDistribution(RandomDistribution.uniform())).between(minInt, maxInt).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new Integer[]{minInt, 0, maxInt}));
        return indexes.map(DefaultZoneOffsetArbitrary::offsetFromValue);
    }

    private ZoneOffset effectiveMax() {
        ZoneOffset offsetMax = this.zoneOffsetBetween.getMax() != null ? (ZoneOffset)this.zoneOffsetBetween.getMax() : DEFAULT_MAX;
        boolean isNegative = offsetMax.getTotalSeconds() < 0;
        int hour = this.hourValue(offsetMax);
        int minute = this.minuteValue(offsetMax);
        int second = this.secondValue(offsetMax);
        if (second != 0 && !isNegative && ++minute > 59) {
            minute -= 60;
            ++hour;
        }
        while (minute % 15 != 0) {
            if (isNegative || (minute += isNegative ? -1 : 1) != 60) continue;
            minute = 0;
            ++hour;
        }
        if (isNegative) {
            minute = -minute;
        }
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }

    private ZoneOffset effectiveMin() {
        ZoneOffset offsetMin = this.zoneOffsetBetween.getMin() != null ? (ZoneOffset)this.zoneOffsetBetween.getMin() : DEFAULT_MIN;
        boolean isNegative = offsetMin.getTotalSeconds() < 0;
        int hour = this.hourValue(offsetMin);
        int minute = this.minuteValue(offsetMin);
        int second = this.secondValue(offsetMin);
        if (second != 0 && isNegative && ++minute > 59) {
            minute -= 60;
            --hour;
        }
        while (minute % 15 != 0) {
            if (!isNegative || (minute -= isNegative ? -1 : 1) != 60) continue;
            minute = 0;
            --hour;
        }
        if (isNegative) {
            minute = -minute;
        }
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }

    private int indexOf(ZoneOffset effective) {
        boolean isNegative = effective.getTotalSeconds() < 0;
        int hour = this.hourValue(effective);
        int minuteVal = this.minuteValue(effective) / 15;
        if (isNegative) {
            minuteVal = -minuteVal;
        }
        return hour * 4 + minuteVal;
    }

    private static ZoneOffset offsetFromValue(int index) {
        int hour = index / 4;
        int minute = (index -= hour * 4) * 15;
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }

    private int hourValue(ZoneOffset offset) {
        return offset.getTotalSeconds() / 3600;
    }

    private int minuteValue(ZoneOffset offset) {
        return Math.abs(offset.getTotalSeconds() % 3600 / 60);
    }

    private int secondValue(ZoneOffset offset) {
        return Math.abs(offset.getTotalSeconds() % 60);
    }

    @Override
    public ZoneOffsetArbitrary between(ZoneOffset min, ZoneOffset max) {
        if (min.compareTo(DEFAULT_MAX) > 0 || max.compareTo(DEFAULT_MAX) > 0 || min.compareTo(DEFAULT_MIN) < 0 || max.compareTo(DEFAULT_MIN) < 0) {
            throw new IllegalArgumentException("Offset must be between -12:00:00 and +14:00:00.");
        }
        DefaultZoneOffsetArbitrary clone = (DefaultZoneOffsetArbitrary)this.typedClone();
        clone.zoneOffsetBetween.set(min, max);
        return clone;
    }
}

