/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.Year;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.arbitraries.YearArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.YearBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultYearArbitrary
extends ArbitraryDecorator<Year>
implements YearArbitrary {
    private static final Year DEFAULT_MIN = Year.of(1900);
    private static final Year DEFAULT_MAX = Year.of(2500);
    private final YearBetween yearBetween = new YearBetween().allowBelow0();

    protected Arbitrary<Year> arbitrary() {
        Year min = this.yearBetween.getMin() != null ? (Year)this.yearBetween.getMin() : DEFAULT_MIN;
        Year max = this.yearBetween.getMax() != null ? (Year)this.yearBetween.getMax() : DEFAULT_MAX;
        Arbitrary years = Arbitraries.integers().between(min.getValue(), max.getValue()).filter(v -> v != 0);
        return years.map(Year::of);
    }

    @Override
    public YearArbitrary between(Year min, Year max) {
        DefaultYearArbitrary clone = (DefaultYearArbitrary)this.typedClone();
        clone.yearBetween.set(min, max);
        return clone;
    }
}

