/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.HourBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.LocalTimeBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.MinuteBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.OfPrecision;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.SecondBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultLocalTimeArbitrary
extends ArbitraryDecorator<LocalTime>
implements LocalTimeArbitrary {
    private final LocalTimeBetween timeBetween = new LocalTimeBetween();
    private final HourBetween hourBetween = (HourBetween)new HourBetween().set(0, 23);
    private final MinuteBetween minuteBetween = (MinuteBetween)new MinuteBetween().set(0, 59);
    private final SecondBetween secondBetween = (SecondBetween)new SecondBetween().set(0, 59);
    private final OfPrecision ofPrecision = new OfPrecision();

    protected Arbitrary<LocalTime> arbitrary() {
        LocalTime effectiveMin = DefaultLocalTimeArbitrary.effectiveMin(this.timeBetween, this.hourBetween, this.minuteBetween, this.secondBetween, this.ofPrecision);
        LocalTime effectiveMax = DefaultLocalTimeArbitrary.effectiveMax(this.timeBetween, this.hourBetween, this.minuteBetween, this.secondBetween, this.ofPrecision);
        long longEnd = this.ofPrecision.longsBetween(effectiveMin, effectiveMax);
        Arbitrary longs = ((LongArbitrary)Arbitraries.longs().withDistribution(RandomDistribution.uniform())).between(0L, longEnd).edgeCases(config -> config.includeOnly((Object[])new Long[]{0L, longEnd}));
        Arbitrary localTimes = longs.map(v -> this.ofPrecision.localTimeFromValue((long)v, effectiveMin));
        localTimes = localTimes.filter(20000, v -> v.getMinute() >= (Integer)this.minuteBetween.getMin() && v.getMinute() <= (Integer)this.minuteBetween.getMax() && v.getSecond() >= (Integer)this.secondBetween.getMin() && v.getSecond() <= (Integer)this.secondBetween.getMax());
        return localTimes;
    }

    public static LocalTime effectiveMin(LocalTimeBetween timeBetween, HourBetween hourBetween, MinuteBetween minuteBetween, SecondBetween secondBetween, OfPrecision ofPrecision) {
        DefaultLocalTimeArbitrary.checkMinValuesAndPrecision(minuteBetween, secondBetween, ofPrecision);
        LocalTime effective = timeBetween.getMin() != null ? (LocalTime)timeBetween.getMin() : LocalTime.MIN;
        DefaultLocalTimeArbitrary.checkTimeValueAndPrecision(effective, ofPrecision, true);
        if ((Integer)hourBetween.getMin() > effective.getHour()) {
            effective = effective.withHour((Integer)hourBetween.getMin());
            effective = effective.withMinute(0);
            effective = effective.withSecond(0);
            effective = effective.withNano(0);
        }
        if ((Integer)minuteBetween.getMin() > effective.getMinute()) {
            effective = effective.withMinute((Integer)minuteBetween.getMin());
            effective = effective.withSecond(0);
            effective = effective.withNano(0);
        }
        if ((Integer)secondBetween.getMin() > effective.getSecond()) {
            effective = effective.withSecond((Integer)secondBetween.getMin());
            effective = effective.withNano(0);
        }
        return effective;
    }

    public static void checkTimeValueAndPrecision(LocalTime time, OfPrecision ofPrecision, boolean minimum) {
        if (!ofPrecision.valueWithPrecisionIsAllowed(time.getMinute(), time.getSecond(), time.getNano())) {
            DefaultLocalTimeArbitrary.throwTimeAndPrecisionException(time.toString(), minimum, ofPrecision.get());
        }
    }

    private static void checkMinValuesAndPrecision(MinuteBetween minuteBetween, SecondBetween secondBetween, OfPrecision ofPrecision) {
        if (ofPrecision.isGreatherThan(ChronoUnit.SECONDS)) {
            if ((Integer)secondBetween.getMin() > 0) {
                DefaultLocalTimeArbitrary.throwValueAndPrecisionException(((Integer)secondBetween.getMin()).toString(), true, "second", ofPrecision.get());
            }
            if (ofPrecision.isGreatherThan(ChronoUnit.MINUTES) && (Integer)minuteBetween.getMin() > 0) {
                DefaultLocalTimeArbitrary.throwValueAndPrecisionException(((Integer)minuteBetween.getMin()).toString(), true, "minute", ofPrecision.get());
            }
        }
    }

    private static void throwValueAndPrecisionException(String val, boolean minimum, String unit, ChronoUnit precision) {
        String minMax = minimum ? "minimum" : "maximum";
        throw new IllegalArgumentException(String.format("Can't use %s as %s %s with precision %s.", val, minMax, unit, precision));
    }

    private static void throwTimeAndPrecisionException(String val, boolean minimum, ChronoUnit precision) {
        String minMax = minimum ? "minimum" : "maximum";
        throw new IllegalArgumentException(String.format("Can't use %s as %s time with precision %s.%nYou may want to round the time to %s or change the precision.", val, minMax, precision, precision));
    }

    public static LocalTime effectiveMax(LocalTimeBetween timeBetween, HourBetween hourBetween, MinuteBetween minuteBetween, SecondBetween secondBetween, OfPrecision ofPrecision) {
        LocalTime effective = timeBetween.getMax() != null ? (LocalTime)timeBetween.getMax() : ofPrecision.maxPossibleLocalTime();
        DefaultLocalTimeArbitrary.checkTimeValueAndPrecision(effective, ofPrecision, false);
        if ((Integer)hourBetween.getMax() < effective.getHour()) {
            effective = effective.withHour((Integer)hourBetween.getMax());
            effective = DefaultLocalTimeArbitrary.effectiveMaxValues(effective, ofPrecision, ChronoUnit.MINUTES);
        }
        if ((Integer)minuteBetween.getMax() < effective.getMinute()) {
            effective = effective.withMinute((Integer)minuteBetween.getMax());
            effective = DefaultLocalTimeArbitrary.effectiveMaxValues(effective, ofPrecision, ChronoUnit.SECONDS);
        }
        if ((Integer)secondBetween.getMax() < effective.getSecond()) {
            effective = effective.withSecond((Integer)secondBetween.getMax());
            effective = DefaultLocalTimeArbitrary.effectiveMaxValues(effective, ofPrecision, ChronoUnit.NANOS);
        }
        return effective;
    }

    private static LocalTime effectiveMaxValues(LocalTime effective, OfPrecision ofPrecision, ChronoUnit precision) {
        switch (precision) {
            case MINUTES: {
                effective = ofPrecision.isLessOrEqualTo(ChronoUnit.MINUTES) ? effective.withMinute(59) : effective.withMinute(0);
            }
            case SECONDS: {
                effective = ofPrecision.isLessOrEqualTo(ChronoUnit.SECONDS) ? effective.withSecond(59) : effective.withSecond(0);
            }
        }
        effective = ofPrecision.effectiveMaxNanos(effective);
        return effective;
    }

    public static ChronoUnit ofPrecisionFromNanos(int nanos) {
        ChronoUnit ofPrecision = OfPrecision.DEFAULT;
        if (nanos % 1000 != 0) {
            ofPrecision = ChronoUnit.NANOS;
        } else if (nanos / 1000 % 1000 != 0) {
            ofPrecision = ChronoUnit.MICROS;
        } else if (nanos / 1000000 != 0) {
            ofPrecision = ChronoUnit.MILLIS;
        }
        return ofPrecision;
    }

    public static ChronoUnit ofPrecisionFromTime(LocalTime time) {
        int nanos = time.getNano();
        return DefaultLocalTimeArbitrary.ofPrecisionFromNanos(nanos);
    }

    private void setOfPrecisionImplicitly(DefaultLocalTimeArbitrary clone, LocalTime time) {
        if (clone.ofPrecision.isSet()) {
            return;
        }
        ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.ofPrecisionFromTime(time);
        if (clone.ofPrecision.isGreatherThan(ofPrecision)) {
            clone.ofPrecision.setProgrammatically(ofPrecision);
        }
    }

    @Override
    public LocalTimeArbitrary atTheEarliest(LocalTime min) {
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.timeBetween.set(min, null);
        this.setOfPrecisionImplicitly(clone, min);
        return clone;
    }

    @Override
    public LocalTimeArbitrary atTheLatest(LocalTime max) {
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.timeBetween.set(null, max);
        this.setOfPrecisionImplicitly(clone, max);
        return clone;
    }

    @Override
    public LocalTimeArbitrary hourBetween(int min, int max) {
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.hourBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalTimeArbitrary minuteBetween(int min, int max) {
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.minuteBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalTimeArbitrary secondBetween(int min, int max) {
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.secondBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalTimeArbitrary ofPrecision(ChronoUnit ofPrecision) {
        DefaultLocalTimeArbitrary clone = (DefaultLocalTimeArbitrary)this.typedClone();
        clone.ofPrecision.set(ofPrecision);
        return clone;
    }
}

