/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.5.1")
public interface OffsetTimeArbitrary
extends Arbitrary<OffsetTime> {
    default public OffsetTimeArbitrary between(LocalTime min, LocalTime max) {
        if (min.isAfter(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public OffsetTimeArbitrary atTheEarliest(LocalTime var1);

    public OffsetTimeArbitrary atTheLatest(LocalTime var1);

    public OffsetTimeArbitrary hourBetween(int var1, int var2);

    public OffsetTimeArbitrary minuteBetween(int var1, int var2);

    public OffsetTimeArbitrary secondBetween(int var1, int var2);

    public OffsetTimeArbitrary offsetBetween(ZoneOffset var1, ZoneOffset var2);

    public OffsetTimeArbitrary ofPrecision(ChronoUnit var1);
}

