/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.5.1")
public interface LocalDateTimeArbitrary
extends Arbitrary<LocalDateTime> {
    default public LocalDateTimeArbitrary between(LocalDateTime min, LocalDateTime max) {
        if (min.isAfter(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public LocalDateTimeArbitrary atTheEarliest(LocalDateTime var1);

    public LocalDateTimeArbitrary atTheLatest(LocalDateTime var1);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary dateBetween(LocalDate var1, LocalDate var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary yearBetween(Year var1, Year var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    default public LocalDateTimeArbitrary yearBetween(int min, int max) {
        return this.yearBetween(Year.of(min), Year.of(max));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary monthBetween(Month var1, Month var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    default public LocalDateTimeArbitrary monthBetween(int min, int max) {
        return this.monthBetween(Month.of(min), Month.of(max));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary onlyMonths(Month ... var1);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary dayOfMonthBetween(int var1, int var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary onlyDaysOfWeek(DayOfWeek ... var1);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary timeBetween(LocalTime var1, LocalTime var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary hourBetween(int var1, int var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary minuteBetween(int var1, int var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary secondBetween(int var1, int var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.5.2")
    public LocalDateTimeArbitrary ofPrecision(ChronoUnit var1);
}

