/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.jqwik.api.Falsifier;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.shrinking.OneAfterTheOtherParameterShrinker;
import net.jqwik.engine.properties.shrinking.PairwiseParameterShrinker;
import net.jqwik.engine.properties.shrinking.ShrinkAndGrowShrinker;

class ShrinkingAlgorithm {
    private final Map<List<Object>, TryExecutionResult> falsificationCache = new LinkedHashMap<List<Object>, TryExecutionResult>();
    private final FalsifiedSample originalSample;
    private final Consumer<FalsifiedSample> sampleShrunkConsumer;
    private final Consumer<FalsifiedSample> shrinkAttemptConsumer;

    ShrinkingAlgorithm(FalsifiedSample originalSample, Consumer<FalsifiedSample> sampleShrunkConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        this.originalSample = originalSample;
        this.sampleShrunkConsumer = sampleShrunkConsumer;
        this.shrinkAttemptConsumer = shrinkAttemptConsumer;
    }

    FalsifiedSample shrink(Falsifier<List<Object>> falsifier) {
        FalsifiedSample before;
        FalsifiedSample after = this.originalSample;
        do {
            if (!(after = this.shrinkOneParameterAfterTheOther(falsifier, before = after, this.sampleShrunkConsumer, this.shrinkAttemptConsumer)).equals((Object)before) || !(after = this.shrinkParametersPairwise(falsifier, after, this.sampleShrunkConsumer, this.shrinkAttemptConsumer)).equals((Object)before)) continue;
            after = this.shrinkAndGrow(falsifier, after, this.sampleShrunkConsumer, this.shrinkAttemptConsumer);
        } while (!after.equals((Object)before));
        return after;
    }

    private FalsifiedSample shrinkOneParameterAfterTheOther(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> sampleShrunkConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new OneAfterTheOtherParameterShrinker(this.falsificationCache).shrink(falsifier, sample, sampleShrunkConsumer, shrinkAttemptConsumer);
    }

    private FalsifiedSample shrinkParametersPairwise(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> sampleShrunkConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new PairwiseParameterShrinker(this.falsificationCache).shrink(falsifier, sample, sampleShrunkConsumer, shrinkAttemptConsumer);
    }

    private FalsifiedSample shrinkAndGrow(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> sampleShrunkConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new ShrinkAndGrowShrinker(this.falsificationCache).shrink(falsifier, sample, sampleShrunkConsumer, shrinkAttemptConsumer);
    }
}

