/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.support.Combinatorics;

class CombinedExhaustiveGenerator<R>
implements ExhaustiveGenerator<R> {
    private final Long maxCount;
    private final List<Arbitrary<Object>> arbitraries;
    private final Function<? super List<?>, ? extends R> combinator;

    static Optional<Long> calculateMaxCount(List<Arbitrary<Object>> arbitraries, long maxNumberOfSamples) {
        long product = 1L;
        for (Arbitrary<Object> arbitrary : arbitraries) {
            Optional exhaustive = arbitrary.exhaustive(maxNumberOfSamples);
            if (!exhaustive.isPresent()) {
                return Optional.empty();
            }
            if ((product *= ((ExhaustiveGenerator)exhaustive.get()).maxCount()) <= maxNumberOfSamples) continue;
            return Optional.empty();
        }
        return Optional.of(product);
    }

    CombinedExhaustiveGenerator(Long maxCount, List<Arbitrary<Object>> arbitraries, Function<? super List<?>, ? extends R> combinator) {
        this.maxCount = maxCount;
        this.arbitraries = arbitraries;
        this.combinator = combinator;
    }

    public long maxCount() {
        return this.maxCount;
    }

    public Iterator<R> iterator() {
        List iterables = this.arbitraries.stream().map(a -> (Iterable)a.exhaustive().get()).collect(Collectors.toList());
        final Iterator valuesIterator = Combinatorics.combine(iterables);
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return valuesIterator.hasNext();
            }

            @Override
            public R next() {
                List values = (List)valuesIterator.next();
                return CombinedExhaustiveGenerator.this.combinator.apply(values);
            }
        };
    }
}

