/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;

public class RecursiveArbitrary<T>
implements Arbitrary<T> {
    private final Supplier<? extends Arbitrary<T>> base;
    private final Function<? super Arbitrary<T>, ? extends Arbitrary<T>> recur;
    private final int depth;
    private final Arbitrary<T> arbitrary;
    private boolean isGeneratorMemoizable = true;

    public RecursiveArbitrary(Supplier<? extends Arbitrary<T>> base, Function<? super Arbitrary<T>, ? extends Arbitrary<T>> recur, int depth) {
        this.base = base;
        this.recur = recur;
        this.depth = depth;
        this.arbitrary = this.iteratedArbitrary();
    }

    public RandomGenerator<T> generator(int genSize) {
        return this.arbitrary.generator(genSize);
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        if (this.depth > 100) {
            return EdgeCases.none();
        }
        return this.arbitrary.edgeCases(maxEdgeCases);
    }

    public boolean isGeneratorMemoizable() {
        return this.isGeneratorMemoizable;
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        Arbitrary<T> current = this.base.get();
        Optional last = current.exhaustive(maxNumberOfSamples);
        for (int i = 0; i < this.depth; ++i) {
            if (!last.isPresent()) {
                return Optional.empty();
            }
            current = this.recur.apply(current);
            last = current.exhaustive(maxNumberOfSamples);
        }
        return last;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveArbitrary that = (RecursiveArbitrary)o;
        if (this.depth != that.depth) {
            return false;
        }
        if (!LambdaSupport.areEqual(this.base, that.base)) {
            return false;
        }
        return LambdaSupport.areEqual(this.recur, that.recur);
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.base.getClass(), this.recur.getClass(), (Object)this.depth);
    }

    private Arbitrary<T> iteratedArbitrary() {
        Arbitrary<T> current = this.base.get();
        this.isGeneratorMemoizable = current.isGeneratorMemoizable();
        for (int i = 0; i < this.depth; ++i) {
            if ((current = this.recur.apply(current)).isGeneratorMemoizable()) continue;
            this.isGeneratorMemoizable = false;
        }
        return current;
    }
}

