/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jqwik.engine.DefaultJqwikConfiguration;
import net.jqwik.engine.JqwikConfiguration;
import net.jqwik.engine.descriptor.JqwikEngineDescriptor;
import net.jqwik.engine.discovery.JqwikDiscoverer;
import net.jqwik.engine.execution.JqwikExecutor;
import net.jqwik.engine.execution.lifecycle.JqwikLifecycleRegistrator;
import net.jqwik.engine.execution.lifecycle.LifecycleHooksRegistry;
import net.jqwik.engine.recording.TestRunRecorder;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;

public class JqwikTestEngine
implements TestEngine {
    public static final String ENGINE_ID = "jqwik";
    private static final Logger LOG = Logger.getLogger(JqwikTestEngine.class.getName());
    private final LifecycleHooksRegistry lifecycleRegistry = new LifecycleHooksRegistry();
    private final Function<ConfigurationParameters, JqwikConfiguration> configurationSupplier;

    public JqwikTestEngine() {
        this(DefaultJqwikConfiguration::new);
    }

    JqwikTestEngine(Function<ConfigurationParameters, JqwikConfiguration> configurationSupplier) {
        this.configurationSupplier = configurationSupplier;
    }

    public String getId() {
        return ENGINE_ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest request, UniqueId uniqueId) {
        JqwikConfiguration configuration = this.buildConfiguration(request.getConfigurationParameters());
        JqwikEngineDescriptor engineDescriptor = new JqwikEngineDescriptor(uniqueId, configuration);
        new JqwikDiscoverer(configuration.testEngineConfiguration().previousRun(), configuration.propertyDefaultValues()).discover(request, (TestDescriptor)engineDescriptor);
        return engineDescriptor;
    }

    public void execute(ExecutionRequest request) {
        JqwikEngineDescriptor root = (JqwikEngineDescriptor)request.getRootTestDescriptor();
        EngineExecutionListener engineExecutionListener = request.getEngineExecutionListener();
        try {
            this.registerLifecycleHooks((TestDescriptor)root, request.getConfigurationParameters());
            this.executeTests(root, engineExecutionListener);
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            JqwikExceptionSupport.throwAsUncheckedException(throwable);
        }
    }

    private void executeTests(JqwikEngineDescriptor root, EngineExecutionListener listener) {
        JqwikConfiguration configuration = root.getConfiguration();
        try (TestRunRecorder recorder = configuration.testEngineConfiguration().recorder();){
            new JqwikExecutor(this.lifecycleRegistry, recorder, configuration.testEngineConfiguration().previousFailures(), configuration.useJunitPlatformReporter(), configuration.reportOnlyFailures()).execute((TestDescriptor)root, listener);
        }
    }

    private void registerLifecycleHooks(TestDescriptor rootDescriptor, ConfigurationParameters configurationParameters) {
        new JqwikLifecycleRegistrator(this.lifecycleRegistry, configurationParameters).registerLifecycleHooks(rootDescriptor);
    }

    private JqwikConfiguration buildConfiguration(ConfigurationParameters configurationParameters) {
        try {
            return this.configurationSupplier.apply(configurationParameters);
        }
        catch (Throwable engineStartupThrowable) {
            return (JqwikConfiguration)JqwikExceptionSupport.throwAsUncheckedException(engineStartupThrowable);
        }
    }
}

