/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.EdgeCasesGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

class WithEdgeCasesGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> base;
    private final int baseToEdgeCaseRatio;
    private final RandomGenerator<T> edgeCasesGenerator;

    WithEdgeCasesGenerator(RandomGenerator<T> base, EdgeCases<T> edgeCases, int genSize) {
        this.base = base;
        this.baseToEdgeCaseRatio = WithEdgeCasesGenerator.calculateBaseToEdgeCaseRatio(genSize, edgeCases.size());
        this.edgeCasesGenerator = WithEdgeCasesGenerator.chooseEdgeCase(edgeCases);
    }

    public Shrinkable<T> next(Random random) {
        if (random.nextInt(this.baseToEdgeCaseRatio) == 0) {
            return this.edgeCasesGenerator.next(random);
        }
        return this.base.next(random);
    }

    private static <T> RandomGenerator<T> chooseEdgeCase(EdgeCases<T> edgeCases) {
        List suppliers = edgeCases.suppliers();
        return random -> (Shrinkable)((Supplier)RandomGenerators.chooseValue(suppliers, random)).get();
    }

    private static int calculateBaseToEdgeCaseRatio(int genSize, int countEdgeCases) {
        return EdgeCasesGenerator.calculateBaseToEdgeCaseRatio(genSize, countEdgeCases);
    }
}

