/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.engine.properties.arbitraries.randomized.DefaultMethodHandleFactory;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.JqwikStringSupport;

abstract class AbstractFunctionGenerator<F, R>
implements RandomGenerator<F> {
    final Class<F> functionalType;
    final RandomGenerator<R> resultGenerator;
    final List<Tuple.Tuple2<Predicate<List<Object>>, Function<List<Object>, R>>> conditions;

    AbstractFunctionGenerator(Class<F> functionalType, RandomGenerator<R> resultGenerator, List<Tuple.Tuple2<Predicate<List<Object>>, Function<List<Object>, R>>> conditions) {
        this.functionalType = functionalType;
        this.resultGenerator = resultGenerator;
        this.conditions = conditions;
    }

    F createFunctionProxy(InvocationHandler handler) {
        return (F)Proxy.newProxyInstance(this.functionalType.getClassLoader(), new Class[]{this.functionalType}, handler);
    }

    public Shrinkable<F> createConstantFunction(Shrinkable<R> shrinkableConstant) {
        return shrinkableConstant.map(this::constantFunction);
    }

    private F constantFunction(R constant) {
        InvocationHandler handler = (proxy, method, args) -> {
            if (JqwikReflectionSupport.isEqualsMethod(method)) {
                return this.handleEqualsMethod(proxy, args);
            }
            if (JqwikReflectionSupport.isToStringMethod(method)) {
                return this.handleToStringOfConstantMethod(constant);
            }
            if (JqwikReflectionSupport.isHashCodeMethod(method)) {
                return HashCodeSupport.hash((Object)constant);
            }
            if (method.isDefault()) {
                return this.handleDefaultMethod(proxy, method, args);
            }
            return this.conditionalResult(args).orElse(new Object[]{constant})[0];
        };
        return this.createFunctionProxy(handler);
    }

    protected Object handleEqualsMethod(Object proxy, Object[] args) {
        return proxy == args[0];
    }

    private Object handleToStringOfConstantMethod(R constant) {
        return String.format("Constant Function<%s>(%s)", this.functionalType.getSimpleName(), JqwikStringSupport.displayString(constant));
    }

    protected Optional<Object[]> conditionalResult(Object[] args) {
        Optional<Object[]> conditionalResult = Optional.empty();
        for (Tuple.Tuple2<Predicate<List<Object>>, Function<List<Object>, R>> condition : this.conditions) {
            List<Object> params = Arrays.asList(args);
            if (!((Predicate)condition.get1()).test(params)) continue;
            Object[] result = new Object[]{((Function)condition.get2()).apply(params)};
            conditionalResult = Optional.of(result);
            break;
        }
        return conditionalResult;
    }

    protected Object handleDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        MethodHandle handle = this.handleForDefaultMethod(method);
        return handle.bindTo(proxy).invokeWithArguments(args);
    }

    protected MethodHandle handleForDefaultMethod(Method method) throws Throwable {
        return new DefaultMethodHandleFactory().create(method);
    }
}

