/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.properties.shrinking.ChooseValueShrinkable;
import net.jqwik.engine.properties.shrinking.CombinedShrinkable;
import net.jqwik.engine.properties.shrinking.FilteredShrinkable;
import net.jqwik.engine.properties.shrinking.FixedValueFlatMappedShrinkable;
import net.jqwik.engine.properties.shrinking.IgnoreExceptionShrinkable;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikStringSupport;

public class EdgeCasesSupport {
    public static <T> EdgeCases<T> fromSuppliers(final List<Supplier<Shrinkable<T>>> suppliers) {
        return new EdgeCases<T>(){

            public List<Supplier<Shrinkable<T>>> suppliers() {
                return suppliers;
            }

            public String toString() {
                String edgeCases = suppliers.stream().map(Supplier::get).map(Shrinkable::value).map(JqwikStringSupport::displayString).collect(Collectors.joining(", "));
                return String.format("EdgeCases[%s]", edgeCases);
            }
        };
    }

    public static <T> EdgeCases<T> choose(List<T> values, int maxEdgeCases) {
        ArrayList<Shrinkable<T>> shrinkables = new ArrayList<Shrinkable<T>>();
        if (values.size() > 0) {
            shrinkables.add(new ChooseValueShrinkable<T>(values.get(0), values));
        }
        if (values.size() > 1 && shrinkables.size() < maxEdgeCases) {
            int lastIndex = values.size() - 1;
            shrinkables.add(new ChooseValueShrinkable<T>(values.get(lastIndex), values));
        }
        try {
            if (values.contains(null) && shrinkables.size() < maxEdgeCases) {
                shrinkables.add(Shrinkable.unshrinkable(null));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return EdgeCasesSupport.fromShrinkables(shrinkables);
    }

    public static <T> EdgeCases<T> concatFrom(List<Arbitrary<T>> arbitraries, int maxEdgeCases) {
        ArrayList<Shrinkable<T>> shrinkables = new ArrayList<Shrinkable<T>>();
        for (Arbitrary<T> arbitrary : arbitraries) {
            shrinkables.add(new ChooseValueShrinkable<Arbitrary<T>>(arbitrary, arbitraries));
        }
        return EdgeCasesSupport.flatMapArbitrary(EdgeCasesSupport.fromShrinkables(shrinkables), Function.identity(), maxEdgeCases);
    }

    public static <T> EdgeCases<T> concat(List<EdgeCases<T>> edgeCases, int maxEdgeCases) {
        if (edgeCases.isEmpty() || maxEdgeCases <= 0) {
            return EdgeCases.none();
        }
        if (edgeCases.size() == 1) {
            return edgeCases.get(0);
        }
        ArrayList<Supplier<Shrinkable<T>>> concatenatedSuppliers = new ArrayList<Supplier<Shrinkable<T>>>();
        int remainingMaxEdgeCases = maxEdgeCases;
        for (EdgeCases<T> edgeCase : edgeCases) {
            if (edgeCase.isEmpty()) continue;
            List suppliers = edgeCase.suppliers().stream().limit(Math.max(0, remainingMaxEdgeCases)).collect(Collectors.toList());
            concatenatedSuppliers.addAll(suppliers);
            remainingMaxEdgeCases -= suppliers.size();
        }
        return EdgeCasesSupport.fromSuppliers(concatenatedSuppliers);
    }

    public static <T> EdgeCases<T> fromShrinkables(List<Shrinkable<T>> shrinkables) {
        return () -> shrinkables.stream().map(shrinkable -> () -> shrinkable).collect(Collectors.toList());
    }

    public static <T, U> EdgeCases<U> map(EdgeCases<T> self, Function<T, U> mapper) {
        return EdgeCasesSupport.mapShrinkable(self, tShrinkable -> tShrinkable.map(mapper));
    }

    public static <T, U> EdgeCases<U> mapShrinkable(EdgeCases<T> self, Function<Shrinkable<T>, Shrinkable<U>> mapper) {
        List mappedSuppliers = self.suppliers().stream().map(tSupplier -> (Shrinkable)mapper.apply((Shrinkable)tSupplier.get())).filter(Objects::nonNull).map(uShrinkable -> () -> uShrinkable).collect(Collectors.toList());
        return EdgeCases.fromSuppliers(mappedSuppliers);
    }

    public static <T> EdgeCases<T> filter(EdgeCases<T> self, Predicate<T> filterPredicate) {
        List filteredSuppliers = self.suppliers().stream().filter(supplier -> filterPredicate.test(((Shrinkable)supplier.get()).value())).map(supplier -> () -> EdgeCasesSupport.lambda$filter$8((Supplier)supplier, filterPredicate)).collect(Collectors.toList());
        return EdgeCases.fromSuppliers(filteredSuppliers);
    }

    public static <T> EdgeCases<T> ignoreExceptions(EdgeCases<T> self, Class<? extends Throwable>[] exceptionTypes) {
        List filteredSuppliers = self.suppliers().stream().filter(supplier -> {
            try {
                ((Shrinkable)supplier.get()).value();
                return true;
            }
            catch (Throwable throwable) {
                if (JqwikExceptionSupport.isInstanceOfAny(throwable, exceptionTypes)) {
                    return false;
                }
                throw throwable;
            }
        }).map(shrinkableSupplier -> () -> EdgeCasesSupport.lambda$ignoreExceptions$11((Supplier)shrinkableSupplier, exceptionTypes)).collect(Collectors.toList());
        return EdgeCases.fromSuppliers(filteredSuppliers);
    }

    public static <T> EdgeCases<T> dontShrink(EdgeCases<T> self) {
        return () -> self.suppliers().stream().map(supplier -> () -> EdgeCasesSupport.lambda$dontShrink$13((Supplier)supplier)).collect(Collectors.toList());
    }

    public static <T, U> EdgeCases<U> flatMapArbitrary(EdgeCases<T> self, Function<T, Arbitrary<U>> mapper, int maxEdgeCases) {
        List flatMappedSuppliers = self.suppliers().stream().flatMap(tSupplier -> {
            Object t = ((Shrinkable)tSupplier.get()).value();
            return ((Arbitrary)mapper.apply(t)).edgeCases(maxEdgeCases).suppliers().stream().map(arg_0 -> EdgeCasesSupport.lambda$flatMapArbitrary$18(mapper, (Supplier)tSupplier, arg_0));
        }).limit(Math.max(0, maxEdgeCases)).collect(Collectors.toList());
        return EdgeCases.fromSuppliers(flatMappedSuppliers);
    }

    public static <T> EdgeCases<T> combine(List<Arbitrary<Object>> arbitraries, Function<List<Object>, T> combineFunction, int maxEdgeCases) {
        if (arbitraries.isEmpty() || maxEdgeCases <= 0) {
            return EdgeCases.none();
        }
        ArrayList listOfSuppliers = new ArrayList();
        int remainingEdgeCases = maxEdgeCases;
        for (Arbitrary<Object> a : arbitraries) {
            EdgeCases edgeCases = a.edgeCases(remainingEdgeCases);
            if (edgeCases.isEmpty()) {
                return EdgeCases.none();
            }
            List supplierList = edgeCases.suppliers();
            listOfSuppliers.add(supplierList);
            remainingEdgeCases = (int)Math.max(1.0, Math.ceil((double)remainingEdgeCases / (double)supplierList.size()));
        }
        Iterator iterator = Combinatorics.combine(listOfSuppliers);
        ArrayList<Supplier<Shrinkable>> suppliers = new ArrayList<Supplier<Shrinkable>>();
        for (int count = 0; iterator.hasNext() && count < maxEdgeCases; ++count) {
            List next = iterator.next();
            List shrinkables = next.stream().map(Supplier::get).collect(Collectors.toList());
            suppliers.add(() -> new CombinedShrinkable(shrinkables, combineFunction));
        }
        return EdgeCases.fromSuppliers(suppliers);
    }

    private static /* synthetic */ Supplier lambda$flatMapArbitrary$18(Function mapper, Supplier tSupplier, Supplier uSupplier) {
        Function<Object, Shrinkable> shrinkableMapper = newT -> ((Arbitrary)mapper.apply(newT)).generator(1000).next(SourceOfRandomness.newRandom(42L));
        return () -> EdgeCasesSupport.lambda$flatMapArbitrary$17((Supplier)tSupplier, shrinkableMapper, (Supplier)uSupplier);
    }

    private static /* synthetic */ Shrinkable lambda$flatMapArbitrary$17(Supplier tSupplier, Function shrinkableMapper, Supplier uSupplier) {
        return new FixedValueFlatMappedShrinkable((Shrinkable)tSupplier.get(), shrinkableMapper, uSupplier);
    }

    private static /* synthetic */ Shrinkable lambda$dontShrink$13(Supplier supplier) {
        return ((Shrinkable)supplier.get()).makeUnshrinkable();
    }

    private static /* synthetic */ Shrinkable lambda$ignoreExceptions$11(Supplier shrinkableSupplier, Class[] exceptionTypes) {
        Shrinkable tShrinkable = (Shrinkable)shrinkableSupplier.get();
        return new IgnoreExceptionShrinkable(tShrinkable, exceptionTypes);
    }

    private static /* synthetic */ Shrinkable lambda$filter$8(Supplier supplier, Predicate filterPredicate) {
        return new FilteredShrinkable((Shrinkable)supplier.get(), filterPredicate);
    }
}

