/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery.predicates;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import net.jqwik.engine.discovery.predicates.IsContainerAGroup;
import net.jqwik.engine.discovery.predicates.IsPotentialTestContainer;
import net.jqwik.engine.discovery.predicates.IsProperty;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class IsTestContainer
implements Predicate<Class<?>> {
    private static final Predicate<Method> isProperty = new IsProperty();
    private static final Predicate<Class<?>> isPotentialTestContainer = new IsPotentialTestContainer();
    private static final Predicate<Class<?>> isGroup = new IsContainerAGroup();

    @Override
    public boolean test(Class<?> candidate) {
        if (!isPotentialTestContainer.test(candidate)) {
            return false;
        }
        return this.hasTests(candidate) || this.hasGroups(candidate);
    }

    private boolean hasTests(Class<?> candidate) {
        return !ReflectionSupport.findMethods(candidate, isProperty, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).isEmpty();
    }

    private boolean hasGroups(Class<?> candidate) {
        return !ReflectionSupport.findNestedClasses(candidate, isGroup).isEmpty();
    }
}

