/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.support.CollectorsSupport;
import net.jqwik.engine.support.GenericsClassContext;
import net.jqwik.engine.support.GenericsSupport;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikKotlinSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.OverriddenMethodAnnotationSupport;
import net.jqwik.engine.support.TypeResolution;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class JqwikReflectionSupport {
    private static final Logger LOG = Logger.getLogger(JqwikReflectionSupport.class.getName());

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    public static <T> T newInstanceWithDefaultConstructor(Class<T> clazz) {
        if (JqwikReflectionSupport.isInnerClass(clazz)) {
            Object parentInstance = JqwikReflectionSupport.newInstanceWithDefaultConstructor(clazz.getDeclaringClass());
            return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[]{parentInstance});
        }
        return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[0]);
    }

    public static List<Object> newInstancesWithDefaultConstructor(Class<?> clazz) {
        if (JqwikReflectionSupport.isInnerClass(clazz)) {
            List<Object> instances = JqwikReflectionSupport.newInstancesWithDefaultConstructor(clazz.getDeclaringClass());
            Object inner = ReflectionSupport.newInstance(clazz, (Object[])new Object[]{instances.get(instances.size() - 1)});
            instances.add(inner);
            return instances;
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        instances.add(ReflectionSupport.newInstance(clazz, (Object[])new Object[0]));
        return instances;
    }

    public static <T> T newInstanceInTestContext(Class<T> clazz, Object context) {
        if (!JqwikReflectionSupport.isInnerClass(clazz)) {
            return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[0]);
        }
        Class<?> outerClass = clazz.getDeclaringClass();
        Object parentInstance = outerClass.isAssignableFrom(context.getClass()) ? context : JqwikReflectionSupport.newInstanceWithDefaultConstructor(outerClass);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(outerClass);
            return JqwikReflectionSupport.newInstance(constructor, parentInstance);
        }
        catch (NoSuchMethodException e) {
            return JqwikExceptionSupport.throwAsUncheckedException(e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        try {
            return JqwikReflectionSupport.makeAccessible(constructor).newInstance(args);
        }
        catch (Throwable t) {
            return JqwikExceptionSupport.throwAsUncheckedException(t);
        }
    }

    public static List<Method> findMethodsPotentiallyOuter(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        List<Class<?>> searchClasses = JqwikReflectionSupport.getDeclaringClasses(clazz, traversalMode);
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (Class<?> searchClass : searchClasses) {
            foundMethods.addAll(ReflectionSupport.findMethods(searchClass, predicate, (HierarchyTraversalMode)traversalMode));
        }
        return foundMethods;
    }

    public static List<Field> findFieldsPotentiallyOuter(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        List<Class<?>> searchClasses = JqwikReflectionSupport.getDeclaringClasses(clazz, traversalMode);
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (Class<?> searchClass : searchClasses) {
            foundFields.addAll(ReflectionSupport.findFields(searchClass, predicate, (HierarchyTraversalMode)traversalMode));
        }
        return foundFields;
    }

    public static Object readFieldOnContainer(Field field, List<Object> targetInstances) {
        JqwikReflectionSupport.makeAccessible(field);
        return JqwikReflectionSupport.readField(field, new ArrayDeque<Object>(targetInstances));
    }

    private static Object readField(Field field, Deque<Object> instances) {
        Object target = instances.removeLast();
        List declaredFields = Arrays.stream(target.getClass().getDeclaredFields()).collect(Collectors.toList());
        if (declaredFields.contains(field)) {
            try {
                return field.get(target);
            }
            catch (Exception exception) {
                return JqwikExceptionSupport.throwAsUncheckedException(exception);
            }
        }
        if (instances.isEmpty()) {
            String message = String.format("Cannot access value of field %s", field);
            throw new JqwikException(message);
        }
        return JqwikReflectionSupport.readField(field, instances);
    }

    public static void setFieldOnContainer(Field field, Object value, List<Object> targetInstances) {
        JqwikReflectionSupport.makeAccessible(field);
        JqwikReflectionSupport.setField(field, value, new ArrayDeque<Object>(targetInstances));
    }

    private static void setField(Field field, Object value, Deque<Object> instances) {
        block6: {
            Object target = instances.removeLast();
            List declaredFields = Arrays.stream(target.getClass().getDeclaredFields()).collect(Collectors.toList());
            if (declaredFields.contains(field)) {
                try {
                    if (JqwikReflectionSupport.isStatic(field)) {
                        field.set(null, value);
                        break block6;
                    }
                    field.set(target, value);
                }
                catch (Exception exception) {
                    JqwikExceptionSupport.throwAsUncheckedException(exception);
                }
            } else {
                if (instances.isEmpty()) {
                    String message = String.format("Cannot set value of field %s", field);
                    throw new JqwikException(message);
                }
                JqwikReflectionSupport.setField(field, value, instances);
            }
        }
    }

    private static List<Class<?>> getDeclaringClasses(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        ArrayList declaringClasses = new ArrayList();
        for (Class<?> nextClass = clazz; nextClass != null; nextClass = nextClass.getDeclaringClass()) {
            if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
                declaringClasses.add(nextClass);
                continue;
            }
            declaringClasses.add(0, nextClass);
        }
        return declaringClasses;
    }

    public static Object invokeMethodOnContainer(Method method, List<Object> instances, Object ... args) {
        return JqwikReflectionSupport.invokeMethod(method, new ArrayDeque<Object>(instances), args);
    }

    private static Object invokeMethod(Method method, Deque<Object> instances, Object ... args) {
        Object target = instances.removeLast();
        if (method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            return ReflectionSupport.invokeMethod((Method)method, (Object)target, (Object[])args);
        }
        if (instances.isEmpty()) {
            String message = String.format("Method [%s] cannot be invoked on target [%s].", method, target);
            throw new IllegalArgumentException(message);
        }
        return JqwikReflectionSupport.invokeMethod(method, instances, args);
    }

    public static Set<Path> getAllClasspathRootDirectories() {
        String classpath = System.getProperty("java.class.path");
        return (Set)Arrays.stream(classpath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(CollectorsSupport.toLinkedHashSet());
    }

    public static List<MethodParameter> getMethodParameters(Executable method, Class<?> containerClass) {
        ArrayList<MethodParameter> list = new ArrayList<MethodParameter>();
        Parameter[] parameters = method.getParameters();
        GenericsClassContext containerClassContext = GenericsSupport.contextFor(containerClass);
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            TypeResolution resolution = containerClassContext.resolveParameter(parameter);
            MethodParameter methodParameter = new MethodParameter(parameter, resolution, i);
            list.add(methodParameter);
        }
        return list;
    }

    public static MethodParameter getMethodParameter(Parameter parameter, int index, Class<?> containerClass) {
        GenericsClassContext containerClassContext = GenericsSupport.contextFor(containerClass);
        TypeResolution resolution = containerClassContext.resolveParameter(parameter);
        return new MethodParameter(parameter, resolution, index);
    }

    public static Optional<Method> findGeneratorMethod(String generatorToFind, Class<?> containerClass, Class<? extends Annotation> requiredGeneratorAnnotation, Function<Method, String> generatorNameSupplier, TypeUsage expectedReturnType) {
        List<Method> creators = JqwikReflectionSupport.findMethodsPotentiallyOuter(containerClass, JqwikReflectionSupport.isGeneratorMethod(expectedReturnType, requiredGeneratorAnnotation), HierarchyTraversalMode.BOTTOM_UP);
        return creators.stream().filter(generatorMethod -> {
            String generatorName = (String)generatorNameSupplier.apply((Method)generatorMethod);
            if (generatorName.isEmpty()) {
                generatorName = JqwikKotlinSupport.javaOrKotlinName(generatorMethod);
            }
            return generatorName.equals(generatorToFind);
        }).findFirst();
    }

    public static <T> Constructor<T> findConstructor(Class<T> type, Class<?> ... parameterTypes) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(parameterTypes);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (Throwable t) {
            return (Constructor)JqwikExceptionSupport.throwAsUncheckedException(t);
        }
    }

    private static Predicate<Method> isGeneratorMethod(TypeUsage expectedReturnType, Class<? extends Annotation> requiredAnnotation) {
        return method -> {
            if (!OverriddenMethodAnnotationSupport.findDeclaredOrInheritedAnnotation(method, requiredAnnotation).isPresent()) {
                return false;
            }
            TypeUsage generatorReturnType = TypeUsage.forType((Type)method.getAnnotatedReturnType().getType());
            return generatorReturnType.canBeAssignedTo(expectedReturnType);
        };
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !ModifierSupport.isStatic(clazz);
    }

    public static boolean isFunctionalType(Class<?> candidateType) {
        if (!candidateType.isInterface()) {
            return false;
        }
        return JqwikReflectionSupport.countInterfaceMethods(candidateType) == 1L;
    }

    private static long countInterfaceMethods(Class<?> candidateType) {
        Method[] methods = candidateType.getMethods();
        return JqwikReflectionSupport.findInterfaceMethods(methods).size();
    }

    private static List<Method> findInterfaceMethods(Method[] methods) {
        return Arrays.stream(methods).filter(m -> !m.isDefault() && !ModifierSupport.isStatic((Member)m)).collect(Collectors.toList());
    }

    public static Optional<Method> getFunctionMethod(Class<?> candidateType) {
        Method[] methods = candidateType.getMethods();
        List<Method> candidates = JqwikReflectionSupport.findInterfaceMethods(methods);
        if (candidates.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(candidates.get(0));
    }

    public static boolean isEqualsMethod(Method method) {
        try {
            return method.equals(Object.class.getDeclaredMethod("equals", Object.class));
        }
        catch (NoSuchMethodException shouldNeverHappen) {
            return false;
        }
    }

    public static boolean isToStringMethod(Method method) {
        try {
            return method.equals(Object.class.getDeclaredMethod("toString", new Class[0]));
        }
        catch (NoSuchMethodException shouldNeverHappen) {
            return false;
        }
    }

    public static boolean isHashCodeMethod(Method method) {
        try {
            return method.equals(Object.class.getDeclaredMethod("hashCode", new Class[0]));
        }
        catch (NoSuchMethodException shouldNeverHappen) {
            return false;
        }
    }

    public static boolean hasDefaultConstructor(Class<?> aClass) {
        return JqwikReflectionSupport.hasConstructor(aClass, new Class[0]);
    }

    public static boolean hasConstructor(Class<?> aClass, Class<?> ... parameterTypes) {
        try {
            aClass.getDeclaredConstructor(parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isJava9orAbove() {
        try {
            Runtime.class.getMethod("version", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isNotStatic(Class<?> clazz) {
        return !JqwikReflectionSupport.isStatic(clazz);
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isNotStatic(Member member) {
        return !JqwikReflectionSupport.isStatic(member);
    }

    public static boolean returnsVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE);
    }

    public static boolean implementsMethod(Class<?> aClass, String methodName, Class<?>[] parameterTypes, Class<?> ignoreImplementationClass) {
        Optional optionalMethod = ReflectionSupport.findMethod(aClass, (String)methodName, (Class[])parameterTypes);
        return optionalMethod.map(method -> !method.getDeclaringClass().equals(ignoreImplementationClass)).orElse(false);
    }

    public static Class<?> extractRawType(Type parameterizedType) {
        if (parameterizedType instanceof Class) {
            return (Class)parameterizedType;
        }
        if (parameterizedType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)parameterizedType).getRawType();
        }
        if (parameterizedType instanceof GenericArrayType) {
            return Object[].class;
        }
        return Object.class;
    }
}

