/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.stateful.Action;
import net.jqwik.engine.properties.stateful.ActionGenerator;

class RandomActionGenerator<T>
implements ActionGenerator<T> {
    private static final int MAX_TRIES = 1000;
    private final RandomGenerator<Action<T>> randomGenerator;
    private final Random random;
    private List<Shrinkable<Action<T>>> shrinkableActions = new ArrayList<Shrinkable<Action<T>>>();

    RandomActionGenerator(Arbitrary<Action<T>> actionArbitrary, int genSize, Random random) {
        this.random = random;
        this.randomGenerator = actionArbitrary.generator(genSize);
    }

    @Override
    public Action<T> next(T model) {
        int tries = 0;
        while (tries++ < 1000) {
            Shrinkable shrinkable = this.randomGenerator.next(this.random);
            boolean precondition = ((Action)shrinkable.value()).precondition(model);
            if (!precondition) continue;
            this.shrinkableActions.add(shrinkable);
            return (Action)shrinkable.value();
        }
        String message = String.format("Could not find action with succeeding precondition after %s tries", tries);
        throw new NoSuchElementException(message);
    }

    @Override
    public List<Shrinkable<Action<T>>> generated() {
        return this.shrinkableActions;
    }
}

