/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.UniquenessChecker;
import net.jqwik.engine.properties.arbitraries.exhaustive.CombinedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.FlatMappedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.IterableBasedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.ListExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.PermutationExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.SetExhaustiveGenerator;

public class ExhaustiveGenerators {
    public static <T> Optional<ExhaustiveGenerator<T>> create(Supplier<T> supplier, long maxNumberOfSamples) {
        return ExhaustiveGenerators.fromIterable(() -> new SupplierIterator(supplier), 1L, maxNumberOfSamples);
    }

    public static <T> Optional<ExhaustiveGenerator<T>> choose(List<T> values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.fromIterable(values, values.size(), maxNumberOfSamples);
    }

    public static Optional<ExhaustiveGenerator<Character>> choose(char[] characters, long maxNumberOfSamples) {
        ArrayList<Character> validCharacters = new ArrayList<Character>(characters.length);
        for (char character : characters) {
            validCharacters.add(Character.valueOf(character));
        }
        return ExhaustiveGenerators.choose(validCharacters, maxNumberOfSamples);
    }

    public static <T> Optional<ExhaustiveGenerator<T>> fromIterable(Iterable<T> iterator, long maxCount, long maxNumberOfSamples) {
        if (maxCount > maxNumberOfSamples) {
            return Optional.empty();
        }
        return Optional.of(new IterableBasedExhaustiveGenerator<T>(iterator, maxCount));
    }

    public static <T> Optional<ExhaustiveGenerator<List<T>>> list(Arbitrary<T> elementArbitrary, int minSize, int maxSize, Collection<FeatureExtractor<T>> uniquenessExtractors, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = ListExhaustiveGenerator.calculateMaxCount(elementArbitrary, minSize, maxSize, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> {
            ListExhaustiveGenerator exhaustiveGenerator = new ListExhaustiveGenerator(elementArbitrary, (Long)maxCount, minSize, maxSize);
            return exhaustiveGenerator.filter(l -> UniquenessChecker.checkUniquenessOfValues(uniquenessExtractors, l), 10000);
        });
    }

    public static Optional<ExhaustiveGenerator<String>> strings(Arbitrary<Character> characterArbitrary, int minLength, int maxLength, long maxNumberOfSamples, boolean uniqueChars) {
        Set featureExtractors = uniqueChars ? Collections.singleton(FeatureExtractor.identity()) : Collections.emptySet();
        return ExhaustiveGenerators.list(characterArbitrary, minLength, maxLength, featureExtractors, maxNumberOfSamples).map(listGenerator -> listGenerator.map(listOfChars -> listOfChars.stream().map(String::valueOf).collect(Collectors.joining())));
    }

    public static <T> Optional<ExhaustiveGenerator<Set<T>>> set(Arbitrary<T> elementArbitrary, int minSize, int maxSize, Collection<FeatureExtractor<T>> featureExtractors, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = SetExhaustiveGenerator.calculateMaxCount(elementArbitrary, minSize, maxSize, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new SetExhaustiveGenerator(elementArbitrary, (long)maxCount, minSize, maxSize).filter(s -> UniquenessChecker.checkUniquenessOfValues(featureExtractors, s), 10000));
    }

    public static <R> Optional<ExhaustiveGenerator<R>> combine(List<Arbitrary<Object>> arbitraries, Function<List<Object>, R> combinator, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = CombinedExhaustiveGenerator.calculateMaxCount(arbitraries, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new CombinedExhaustiveGenerator((Long)maxCount, arbitraries, combinator));
    }

    public static <T> Optional<ExhaustiveGenerator<List<T>>> shuffle(List<T> values, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = PermutationExhaustiveGenerator.calculateMaxCount(values, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new PermutationExhaustiveGenerator(values, (Long)maxCount));
    }

    public static <U, T> Optional<ExhaustiveGenerator<U>> flatMap(ExhaustiveGenerator<T> base, Function<T, Arbitrary<U>> mapper, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = FlatMappedExhaustiveGenerator.calculateMaxCounts(base, mapper, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new FlatMappedExhaustiveGenerator(base, (long)maxCount, mapper));
    }

    private static class SupplierIterator<T>
    implements Iterator<T> {
        private final Supplier<T> supplier;
        private volatile boolean generated = false;

        private SupplierIterator(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean hasNext() {
            return !this.generated;
        }

        @Override
        public T next() {
            if (this.generated) {
                throw new NoSuchElementException();
            }
            this.generated = true;
            return this.supplier.get();
        }
    }
}

