/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.engine.execution.reporting.BuilderBasedLineReporter;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.ValueReport;

public class SampleReporter {
    public static final int MAX_LINE_LENGTH = 100;
    private final String headline;
    private final Map<String, Object> reports;
    private final Collection<SampleReportingFormat> sampleReportingFormats;

    static void reportSample(StringBuilder stringBuilder, Method propertyMethod, List<Object> sample, String headline, int indentLevel, Collection<SampleReportingFormat> sampleReportingFormats) {
        Map<String, Object> reports = SampleReporter.createSampleReports(propertyMethod, sample);
        SampleReporter sampleReporter = new SampleReporter(headline, reports, sampleReportingFormats);
        BuilderBasedLineReporter lineReporter = new BuilderBasedLineReporter(stringBuilder, indentLevel);
        sampleReporter.reportTo(lineReporter);
    }

    public static Map<String, Object> createSampleReports(Method propertyMethod, List<Object> sample) {
        if (sample.size() != propertyMethod.getParameters().length) {
            throw new IllegalArgumentException("Number of sample parameters must be equal to number of parameter names");
        }
        List<String> parameterNames = Arrays.stream(propertyMethod.getParameters()).map(Parameter::getName).collect(Collectors.toList());
        return SampleReporter.createReports(sample, parameterNames);
    }

    private static Map<String, Object> createReports(List<Object> sample, List<String> parameterNames) {
        LinkedHashMap<String, Object> samples = new LinkedHashMap<String, Object>();
        for (int i = 0; i < sample.size(); ++i) {
            String parameterName = parameterNames.get(i);
            Object parameter = sample.get(i);
            samples.put(parameterName, parameter);
        }
        return samples;
    }

    SampleReporter(String headline, Map<String, Object> reports, Collection<SampleReportingFormat> sampleReportingFormats) {
        this.reports = reports;
        this.headline = headline;
        this.sampleReportingFormats = sampleReportingFormats;
    }

    void reportTo(LineReporter lineReporter) {
        lineReporter.addLine(0, "");
        this.reportHeadline(lineReporter);
        this.reportParameters(lineReporter);
    }

    private void reportParameters(LineReporter lineReporter) {
        for (Map.Entry<String, Object> nameAndValue : this.reports.entrySet()) {
            String line;
            String parameterName = nameAndValue.getKey();
            Object parameterValue = nameAndValue.getValue();
            ValueReport sampleReport = ValueReport.of(parameterValue, this.sampleReportingFormats);
            if (sampleReport.singleLineLength() + parameterName.length() < 100) {
                line = String.format("%s: %s", parameterName, sampleReport.singleLineReport());
                lineReporter.addLine(1, line);
                continue;
            }
            line = String.format("%s:", parameterName);
            lineReporter.addLine(1, line);
            sampleReport.report(lineReporter, 2, "");
        }
    }

    private void reportHeadline(LineReporter lineReporter) {
        if (this.headline == null) {
            return;
        }
        lineReporter.addLine(0, this.headline);
        lineReporter.addUnderline(0, this.headline.length());
    }
}

