/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

public class DefaultIteratorArbitrary<T>
extends MultivalueArbitraryBase<T, Iterator<T>>
implements IteratorArbitrary<T> {
    public DefaultIteratorArbitrary(Arbitrary<T> elementArbitrary) {
        super(elementArbitrary);
    }

    @Override
    protected Iterable<T> toIterable(Iterator<T> streamable) {
        return () -> streamable;
    }

    public RandomGenerator<Iterator<T>> generator(int genSize) {
        return this.createListGenerator(genSize, false).map(List::iterator);
    }

    public RandomGenerator<Iterator<T>> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.createListGenerator(genSize, true).map(List::iterator);
    }

    public Optional<ExhaustiveGenerator<Iterator<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize(), this.uniquenessExtractors, maxNumberOfSamples).map(generator -> generator.map(List::iterator));
    }

    public EdgeCases<Iterator<T>> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.edgeCases((elements, minimalSize) -> new ShrinkableList(elements, (int)minimalSize, this.maxSize(), this.uniquenessExtractors, this.elementArbitrary), maxEdgeCases), List::iterator);
    }

    public IteratorArbitrary<T> ofMaxSize(int maxSize) {
        return (IteratorArbitrary)super.ofMaxSize(maxSize);
    }

    public IteratorArbitrary<T> ofMinSize(int minSize) {
        return (IteratorArbitrary)super.ofMinSize(minSize);
    }

    public IteratorArbitrary<T> withSizeDistribution(RandomDistribution distribution) {
        return (IteratorArbitrary)super.withSizeDistribution(distribution);
    }

    public IteratorArbitrary<T> uniqueElements(Function<T, Object> by) {
        FeatureExtractor featureExtractor = by::apply;
        return (IteratorArbitrary)super.uniqueElements(featureExtractor);
    }

    public IteratorArbitrary<T> uniqueElements() {
        return (IteratorArbitrary)super.uniqueElements();
    }
}

