/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.combinatorics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class CombinedIterator<T>
implements Iterator<List<T>> {
    private final List<Iterable<T>> iterables;
    private final List<Iterator<T>> iterators;
    private final List<T> elements;
    private final boolean isEmpty;
    private int position = -1;

    public CombinedIterator(List<Iterable<T>> iterables) {
        this.iterables = iterables;
        this.elements = new ArrayList<Object>(Collections.nCopies(iterables.size(), null));
        this.iterators = iterables.stream().map(Iterable::iterator).collect(Collectors.toCollection(ArrayList::new));
        this.isEmpty = iterables.isEmpty() || !this.iterators.stream().allMatch(Iterator::hasNext);
    }

    @Override
    public boolean hasNext() {
        if (this.isEmpty) {
            return false;
        }
        return this.position == -1 || this.nextAvailablePosition() != -1;
    }

    @Override
    public List<T> next() {
        if (this.isEmpty) {
            throw new NoSuchElementException();
        }
        if (this.position == -1) {
            this.resetValuesFrom(0);
        } else {
            Iterator<T> it = this.iterators.get(this.position);
            if (it.hasNext()) {
                this.elements.set(this.position, it.next());
            } else {
                --this.position;
                int nextPosition = this.nextAvailablePosition();
                if (nextPosition == -1) {
                    throw new NoSuchElementException();
                }
                this.elements.set(nextPosition, this.iterators.get(nextPosition).next());
                this.resetValuesFrom(nextPosition + 1);
            }
        }
        return new ArrayList<T>(this.elements);
    }

    private void resetValuesFrom(int startPosition) {
        List<Iterator<T>> iterators = this.iterators;
        List<Iterable<T>> iterables = this.iterables;
        List<T> elements = this.elements;
        boolean initialReset = this.position == -1;
        for (int i = startPosition; i < iterables.size(); ++i) {
            Iterator<T> newIt = initialReset ? iterators.get(i) : iterables.get(i).iterator();
            iterators.set(i, newIt);
            elements.set(i, newIt.next());
        }
        this.position = iterables.size() - 1;
    }

    private int nextAvailablePosition() {
        List<Iterator<T>> iterators = this.iterators;
        for (int i = this.position; i >= 0; --i) {
            if (!iterators.get(i).hasNext()) continue;
            return i;
        }
        return -1;
    }
}

