/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.TooManyFilterMissesException;

public class FilteredExhaustiveGenerator<T>
implements ExhaustiveGenerator<T> {
    private final ExhaustiveGenerator<T> toFilter;
    private final Predicate<T> filter;
    private int maxMisses;

    public FilteredExhaustiveGenerator(ExhaustiveGenerator<T> toFilter, Predicate<T> filter, int maxMisses) {
        this.toFilter = toFilter;
        this.filter = filter;
        this.maxMisses = maxMisses;
    }

    public long maxCount() {
        return this.toFilter.maxCount();
    }

    public Iterator<T> iterator() {
        final Iterator mappedIterator = this.toFilter.iterator();
        return new Iterator<T>(){
            T next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = this.findNext();
                return result;
            }

            private T findNext() {
                for (int i = 0; i < FilteredExhaustiveGenerator.this.maxMisses; ++i) {
                    if (!mappedIterator.hasNext()) {
                        return null;
                    }
                    Object value = mappedIterator.next();
                    if (!FilteredExhaustiveGenerator.this.filter.test(value)) continue;
                    return value;
                }
                String message = String.format("Filter missed more than %s times.", FilteredExhaustiveGenerator.this.maxMisses);
                throw new TooManyFilterMissesException(message);
            }
        };
    }
}

