/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.List;
import java.util.Optional;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.ValueReport;
import net.jqwik.engine.support.JqwikStringSupport;

class ObjectValueReport
extends ValueReport {
    private List<String> lines;

    ObjectValueReport(Optional<String> header, Object value) {
        super(header);
        this.lines = this.toStringLines(value);
    }

    private List<String> toStringLines(Object value) {
        String s = JqwikStringSupport.displayString(value);
        return JqwikStringSupport.toLines(s);
    }

    @Override
    public String singleLineReport() {
        return this.label.orElse("") + String.join((CharSequence)" ", this.lines);
    }

    @Override
    public void report(LineReporter lineReporter, int indentLevel, String appendix) {
        this.label.ifPresent(headerString -> lineReporter.addLine(indentLevel, (String)headerString));
        int linesIndentLevel = this.label.map(ignore -> indentLevel + 1).orElse(indentLevel);
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            boolean isNotLastLine = i < this.lines.size() - 1;
            String optionalAppendix = isNotLastLine ? "" : appendix;
            lineReporter.addLine(linesIndentLevel, line + optionalAppendix);
        }
    }
}

