/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.FalsifiedSampleImpl;
import net.jqwik.engine.properties.shrinking.ShrinkingAlgorithm;

public class ShrunkSampleRecreator {
    private final List<Shrinkable<Object>> shrinkables;

    public ShrunkSampleRecreator(List<Shrinkable<Object>> shrinkables) {
        this.shrinkables = shrinkables;
    }

    public Optional<List<Shrinkable<Object>>> recreateFrom(List<TryExecutionResult.Status> shrinkingSequence) {
        ArrayList<TryExecutionResult.Status> recreatingSequence = new ArrayList<TryExecutionResult.Status>(shrinkingSequence);
        Falsifier<List<Object>> recreatingFalsifier = this.falsifier(recreatingSequence);
        FalsifiedSample originalSample = this.createFalsifiedSample();
        AtomicInteger shrinkingSteps = new AtomicInteger(0);
        FalsifiedSample[] currentBest = new FalsifiedSample[]{originalSample};
        Consumer<FalsifiedSample> sampleShrunkConsumer = shrunkSample -> {
            currentBest[0] = shrunkSample;
            shrinkingSteps.incrementAndGet();
        };
        ShrinkingAlgorithm plainShrinker = new ShrinkingAlgorithm(originalSample, sampleShrunkConsumer, ignore -> {});
        try {
            FalsifiedSample falsifiedSample = plainShrinker.shrink(recreatingFalsifier);
        }
        catch (RecreationDone recreationDone) {
            // empty catch block
        }
        if (recreatingSequence.isEmpty()) {
            return Optional.of(currentBest[0].shrinkables());
        }
        return Optional.empty();
    }

    private FalsifiedSample createFalsifiedSample() {
        List<Object> parameters = this.shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
        return new FalsifiedSampleImpl(parameters, this.shrinkables, null, Collections.emptyList());
    }

    private Falsifier<List<Object>> falsifier(List<TryExecutionResult.Status> recreatingSequence) {
        return ignore -> {
            if (!recreatingSequence.isEmpty()) {
                TryExecutionResult.Status next = (TryExecutionResult.Status)recreatingSequence.remove(0);
                switch (next) {
                    case SATISFIED: {
                        return TryExecutionResult.satisfied();
                    }
                    case INVALID: {
                        return TryExecutionResult.invalid();
                    }
                    case FALSIFIED: {
                        return TryExecutionResult.falsified(null);
                    }
                }
            }
            throw new RecreationDone();
        };
    }

    private static class RecreationDone
    extends RuntimeException {
        private RecreationDone() {
        }
    }
}

