/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.DecimalGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.MappedEdgeCasesConsumer;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultFloatArbitrary
extends TypedCloneable
implements FloatArbitrary {
    private static final float DEFAULT_MIN = -3.4028235E38f;
    private static final float DEFAULT_MAX = Float.MAX_VALUE;
    private DecimalGeneratingArbitrary generatingArbitrary;
    private final Set<Float> specials = new LinkedHashSet<Float>();

    public DefaultFloatArbitrary() {
        this.generatingArbitrary = new DecimalGeneratingArbitrary(Range.of(this.toBigDecimal(-3.4028235E38f), this.toBigDecimal(Float.MAX_VALUE)));
    }

    public RandomGenerator<Float> generator(int genSize) {
        return this.arbitrary().generator(genSize);
    }

    public Optional<ExhaustiveGenerator<Float>> exhaustive(long maxNumberOfSamples) {
        return this.arbitrary().exhaustive(maxNumberOfSamples);
    }

    public EdgeCases<Float> edgeCases(int maxEdgeCases) {
        return this.arbitrary().edgeCases(maxEdgeCases);
    }

    public Arbitrary<Float> edgeCases(Consumer<EdgeCases.Config<Float>> configurator) {
        MappedEdgeCasesConsumer<Float, BigDecimal> decimalConfigurator = new MappedEdgeCasesConsumer<Float, BigDecimal>(configurator, BigDecimal::floatValue, BigDecimal::valueOf);
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary = (DecimalGeneratingArbitrary)this.generatingArbitrary.edgeCases(decimalConfigurator);
        return clone;
    }

    public FloatArbitrary withDistribution(RandomDistribution distribution) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public FloatArbitrary between(float min, boolean minIncluded, float max, boolean maxIncluded) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.range = Range.of(this.toBigDecimal(min), minIncluded, this.toBigDecimal(max), maxIncluded);
        return clone;
    }

    public FloatArbitrary greaterOrEqual(float min) {
        return this.between(min, true, ((BigDecimal)this.generatingArbitrary.range.max).floatValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public FloatArbitrary greaterThan(float min) {
        return this.between(min, false, ((BigDecimal)this.generatingArbitrary.range.max).floatValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public FloatArbitrary lessOrEqual(float max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).floatValue(), this.generatingArbitrary.range.minIncluded, max, true);
    }

    public FloatArbitrary lessThan(float max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).floatValue(), this.generatingArbitrary.range.minIncluded, max, false);
    }

    public FloatArbitrary ofScale(int scale) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.scale = scale;
        return clone;
    }

    public FloatArbitrary shrinkTowards(float target) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigDecimal.valueOf(target);
        return clone;
    }

    public FloatArbitrary withSpecialValue(float special) {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.specials.add(Float.valueOf(special));
        return clone;
    }

    public FloatArbitrary withStandardSpecialValues() {
        DefaultFloatArbitrary clone = (DefaultFloatArbitrary)this.typedClone();
        clone.specials.add(Float.valueOf(Float.NaN));
        clone.specials.add(Float.valueOf(Float.MIN_VALUE));
        clone.specials.add(Float.valueOf(Float.MIN_NORMAL));
        clone.specials.add(Float.valueOf(Float.POSITIVE_INFINITY));
        clone.specials.add(Float.valueOf(Float.NEGATIVE_INFINITY));
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFloatArbitrary that = (DefaultFloatArbitrary)o;
        if (!this.generatingArbitrary.equals(that.generatingArbitrary)) {
            return false;
        }
        return this.specials.equals(that.specials);
    }

    public int hashCode() {
        return HashCodeSupport.hash((Object)this.generatingArbitrary, this.specials);
    }

    private Arbitrary<Float> arbitrary() {
        Arbitrary floatArbitrary = this.generatingArbitrary.map(BigDecimal::floatValue);
        if (this.specials.isEmpty()) {
            return floatArbitrary;
        }
        Arbitrary specialsArbitrary = Arbitraries.of(this.specials).edgeCases(c -> c.add((Object[])this.specials.toArray(new Float[0])));
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)49, (Object)floatArbitrary), Tuple.of((Object)1, (Object)specialsArbitrary)});
    }

    private BigDecimal toBigDecimal(float value) {
        return new BigDecimal(Float.toString(value));
    }
}

