/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery.specs;

import java.util.function.Predicate;
import net.jqwik.api.Group;
import net.jqwik.engine.discovery.predicates.IsPotentialTestContainer;
import net.jqwik.engine.discovery.predicates.IsTopLevelClass;
import net.jqwik.engine.discovery.specs.DiscoverySpec;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.engine.support.hierarchical.Node;

public class TopLevelContainerDiscoverySpec
implements DiscoverySpec<Class<?>> {
    private static final Predicate<Class<?>> isPotentialTestContainer = new IsPotentialTestContainer();
    private static final Predicate<Class<?>> isTopLevelClass = new IsTopLevelClass();
    private static final Predicate<Class<?>> isGroup = candidate -> candidate.isAnnotationPresent(Group.class);
    private static final Predicate<Class<?>> isStaticNonGroupMember = candidate -> ModifierSupport.isStatic((Class)candidate) && !isGroup.test((Class<?>)candidate);

    @Override
    public boolean shouldBeDiscovered(Class<?> candidate) {
        return isPotentialTestContainer.and(isTopLevelClass.or(isStaticNonGroupMember)).test(candidate);
    }

    @Override
    public Node.SkipResult shouldBeSkipped(Class<?> candidate) {
        return Node.SkipResult.doNotSkip();
    }
}

