/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.TypeArbitrary;
import net.jqwik.api.constraints.UseType;
import net.jqwik.api.constraints.UseTypeMode;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;

public class UseTypeArbitraryProvider
implements ArbitraryProvider {
    private static final Logger LOG = Logger.getLogger(UseTypeArbitraryProvider.class.getName());

    public boolean canProvideFor(TypeUsage targetType) {
        if (!targetType.isAnnotated(UseType.class)) {
            return false;
        }
        if (!targetType.getTypeArguments().isEmpty()) {
            String message = String.format("@UseType cannot be applied to parameterized types.%nTry to apply it to the type parameters themselves!", new Object[0]);
            LOG.warning(message);
            return false;
        }
        return true;
    }

    public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        return Collections.singleton(this.createForTypeArbitrary(targetType));
    }

    private TypeArbitrary<?> createForTypeArbitrary(TypeUsage targetType) {
        TypeArbitrary typeArbitrary = Arbitraries.forType((Class)targetType.getRawType());
        UseTypeMode[] uses = targetType.findAnnotation(UseType.class).map(UseType::value).orElse(new UseTypeMode[0]);
        boolean allowRecursion = targetType.findAnnotation(UseType.class).map(UseType::enableRecursion).orElse(true);
        for (UseTypeMode use : uses) {
            typeArbitrary = use.modify(typeArbitrary);
        }
        if (allowRecursion) {
            typeArbitrary = typeArbitrary.enableRecursion();
        }
        return typeArbitrary;
    }

    public int priority() {
        return 1;
    }
}

