/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.state;

import java.util.Optional;
import java.util.function.Predicate;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.state.Transformer;

class ShrinkableChainIteration<T> {
    final Shrinkable<Transformer<T>> shrinkable;
    private final Predicate<T> precondition;
    final boolean accessState;
    final boolean changeState;

    ShrinkableChainIteration(Predicate<T> precondition, boolean accessState, Shrinkable<Transformer<T>> shrinkable) {
        this(precondition, accessState, true, shrinkable);
    }

    private ShrinkableChainIteration(Predicate<T> precondition, boolean accessState, boolean changeState, Shrinkable<Transformer<T>> shrinkable) {
        this.precondition = precondition;
        this.accessState = accessState;
        this.changeState = changeState;
        this.shrinkable = shrinkable;
    }

    public String toString() {
        return String.format("Iteration[accessState=%s, changeState=%s, transformation=%s]", this.accessState, this.changeState, ((Transformer)this.shrinkable.value()).transformation());
    }

    boolean isEndOfChain() {
        return ((Transformer)this.shrinkable.value()).equals(Transformer.END_OF_CHAIN);
    }

    Optional<Predicate<T>> precondition() {
        return Optional.ofNullable(this.precondition);
    }

    ShrinkableChainIteration<T> withShrinkable(Shrinkable<Transformer<T>> shrinkable) {
        return new ShrinkableChainIteration<T>(this.precondition, this.accessState, this.changeState, shrinkable);
    }

    ShrinkableChainIteration<T> withStateChange(boolean stateHasBeenChanged) {
        if (this.changeState == stateHasBeenChanged) {
            return this;
        }
        return new ShrinkableChainIteration<T>(this.precondition, this.accessState, stateHasBeenChanged, this.shrinkable);
    }

    String transformation() {
        return this.transformer().transformation();
    }

    Transformer<T> transformer() {
        return (Transformer)this.shrinkable.value();
    }
}

