/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.shrinking.ShrinkingCommons;
import net.jqwik.engine.support.JqwikStreamSupport;

public class CollectShrinkable<T>
implements Shrinkable<List<T>> {
    private final List<Shrinkable<T>> elements;
    private final Predicate<List<T>> until;

    public CollectShrinkable(List<Shrinkable<T>> elements, Predicate<List<T>> until) {
        this.elements = elements;
        this.until = until;
    }

    public List<T> value() {
        return this.createValue(this.elements);
    }

    private List<T> createValue(List<Shrinkable<T>> elements) {
        return elements.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    public Stream<Shrinkable<List<T>>> shrink() {
        return JqwikStreamSupport.concat(this.shrinkElementsOneAfterTheOther(), this.sortElements()).filter(s -> this.until.test((List)s.value()));
    }

    private Stream<Shrinkable<List<T>>> shrinkElementsOneAfterTheOther() {
        ArrayList shrinkPerPartStreams = new ArrayList();
        for (int i = 0; i < this.elements.size(); ++i) {
            int index = i;
            Shrinkable<T> part = this.elements.get(i);
            Stream shrinkElement = part.shrink().flatMap(shrunkElement -> {
                Optional<List<Shrinkable<List>>> shrunkCollection = this.collectElements(index, (Shrinkable<T>)shrunkElement);
                return shrunkCollection.map(shrunkElements -> Stream.of(this.createShrinkable((List<Shrinkable<T>>)shrunkElements))).orElse(Stream.empty());
            });
            shrinkPerPartStreams.add(shrinkElement);
        }
        return JqwikStreamSupport.concat(shrinkPerPartStreams);
    }

    private Stream<Shrinkable<List<T>>> sortElements() {
        return ShrinkingCommons.sortElements(this.elements, this::createShrinkable);
    }

    private CollectShrinkable<T> createShrinkable(List<Shrinkable<T>> pairSwap) {
        return new CollectShrinkable<T>(pairSwap, this.until);
    }

    private Optional<List<Shrinkable<T>>> collectElements(int replaceIndex, Shrinkable<T> shrunkElement) {
        ArrayList<Shrinkable<T>> newElements = new ArrayList<Shrinkable<T>>();
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i == replaceIndex) {
                newElements.add(shrunkElement);
            } else {
                newElements.add(this.elements.get(i));
            }
            if (!this.until.test(this.createValue(newElements))) continue;
            return Optional.of(newElements);
        }
        return Optional.empty();
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.forCollection(this.elements);
    }
}

