/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class OneOfArbitrary<T>
implements Arbitrary<T>,
SelfConfiguringArbitrary<T> {
    private final List<Arbitrary<T>> all = new ArrayList<Arbitrary<T>>();
    private final boolean isGeneratorMemoizable;

    public OneOfArbitrary(Collection<Arbitrary<? extends T>> choices) {
        for (Arbitrary<T> arbitrary : choices) {
            this.all.add(arbitrary);
        }
        this.isGeneratorMemoizable = this.all.stream().allMatch(Arbitrary::isGeneratorMemoizable);
    }

    public RandomGenerator<T> generator(int genSize) {
        return this.rawGeneration(genSize, false);
    }

    public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.rawGeneration(genSize, true);
    }

    public boolean isGeneratorMemoizable() {
        return this.isGeneratorMemoizable;
    }

    private RandomGenerator<T> rawGeneration(int genSize, boolean withEmbeddedEdgeCases) {
        List frequencies = this.all.stream().map(a -> Tuple.of((Object)1, (Object)a)).collect(Collectors.toList());
        return RandomGenerators.frequencyOf(frequencies, genSize, withEmbeddedEdgeCases);
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(this.all, maxNumberOfSamples).flatMap(generator -> ExhaustiveGenerators.flatMap(generator, Function.identity(), maxNumberOfSamples));
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.concatFrom(this.all, maxEdgeCases);
    }

    public Arbitrary<T> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        this.all.replaceAll(arbitrary -> SelfConfiguringArbitrary.configure((Arbitrary)arbitrary, (ArbitraryConfigurator)configurator, (TypeUsage)targetType));
        return configurator.configure((Arbitrary)this, targetType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneOfArbitrary that = (OneOfArbitrary)o;
        return this.all.equals(that.all);
    }

    public int hashCode() {
        return this.all.hashCode();
    }
}

