/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.lifecycle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.engine.hooks.lifecycle.LifecycleMethods;
import net.jqwik.engine.hooks.lifecycle.MethodParameterResolver;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class PropertyLifecycleMethodsHook
implements AroundPropertyHook {
    private void beforeProperty(PropertyLifecycleContext context) {
        List<Method> beforeContainerMethods = LifecycleMethods.findBeforePropertyMethods(context.containerClass());
        this.callPropertyMethods(beforeContainerMethods, context);
    }

    private void callPropertyMethods(List<Method> methods, PropertyLifecycleContext context) {
        Object testInstance = context.testInstance();
        ThrowableCollector throwableCollector = new ThrowableCollector(ignore -> false);
        for (Method method : methods) {
            Object[] parameters = MethodParameterResolver.resolveParameters(method, (LifecycleContext)context);
            throwableCollector.execute(() -> this.callMethod(method, testInstance, parameters));
        }
        throwableCollector.assertEmpty();
    }

    private void callMethod(Method method, Object target, Object[] parameters) {
        JqwikReflectionSupport.invokeMethodPotentiallyOuter(method, target, parameters);
    }

    private void afterProperty(PropertyLifecycleContext context) {
        List<Method> afterContainerMethods = LifecycleMethods.findAfterPropertyMethods(context.containerClass());
        this.callPropertyMethods(afterContainerMethods, context);
    }

    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    public boolean appliesTo(Optional<AnnotatedElement> element) {
        return element.map(e -> e instanceof Method).orElse(false);
    }

    public int aroundPropertyProximity() {
        return -10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) {
        this.beforeProperty(context);
        try {
            PropertyExecutionResult propertyExecutionResult = property.execute();
            return propertyExecutionResult;
        }
        finally {
            this.afterProperty(context);
        }
    }
}

