/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.JavaBeanReportingFormat;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.api.Tuple;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class JavaBeanReportingFormatFacadeImpl
extends JavaBeanReportingFormat.JavaBeanReportingFormatFacade {
    public Object reportJavaBean(Object bean, boolean reportNulls, Collection<String> excludeProperties, Function<List<String>, List<String>> sortProperties) {
        LinkedHashMap report = new LinkedHashMap();
        List<Tuple.Tuple2<String, Method>> properties = Arrays.stream(bean.getClass().getMethods()).filter(method -> !JqwikReflectionSupport.isStatic(method)).filter(method -> method.getParameters().length == 0).filter(method -> !method.getName().equals("getClass")).filter(method -> !method.getName().equals("get")).filter(method -> !method.getName().equals("is")).filter(method -> method.getName().startsWith("get") || method.getName().startsWith("is")).map(method -> Tuple.of((Object)this.extractPropertyName((Method)method), (Object)method)).sorted(Comparator.comparing(Tuple.Tuple1::get1)).filter(tuple -> !excludeProperties.contains(tuple.get1())).collect(Collectors.toList());
        this.resort(properties, sortProperties).forEach(tuple -> this.appendGetterToReport(report, reportNulls, (Tuple.Tuple2<String, Method>)tuple, bean));
        return report;
    }

    private Iterable<Tuple.Tuple2<String, Method>> resort(List<Tuple.Tuple2<String, Method>> properties, Function<List<String>, List<String>> nameSorter) {
        List unsortedNames = properties.stream().map(p -> (String)p.get1()).collect(Collectors.toList());
        List<String> sortedNames = nameSorter.apply(unsortedNames);
        ArrayList<Tuple.Tuple2<String, Method>> sortedProperties = new ArrayList<Tuple.Tuple2<String, Method>>();
        Map<String, Tuple.Tuple2<String, Method>> propertyMap = this.toMap(properties);
        for (String name : sortedNames) {
            Tuple.Tuple2<String, Method> entry = propertyMap.get(name);
            if (entry == null) continue;
            sortedProperties.add(entry);
        }
        return sortedProperties;
    }

    private Map<String, Tuple.Tuple2<String, Method>> toMap(List<Tuple.Tuple2<String, Method>> properties) {
        LinkedHashMap<String, Tuple.Tuple2<String, Method>> map = new LinkedHashMap<String, Tuple.Tuple2<String, Method>>();
        for (Tuple.Tuple2<String, Method> entry : properties) {
            map.put((String)entry.get1(), entry);
        }
        return map;
    }

    private void appendGetterToReport(Map<Object, Object> report, boolean reportNulls, Tuple.Tuple2<String, Method> method, Object bean) {
        this.maybeAppend(report, reportNulls, (String)method.get1(), () -> {
            try {
                return ReflectionSupport.invokeMethod((Method)((Method)method.get2()), (Object)bean, (Object[])new Object[0]);
            }
            catch (Throwable e) {
                JqwikExceptionSupport.rethrowIfBlacklisted(e);
                return "<illegal access>";
            }
        });
    }

    private String extractPropertyName(Method method) {
        String methodName = method.getName();
        String name = methodName.startsWith("get") ? methodName.substring(3) : (methodName.startsWith("is") ? methodName.substring(2) : methodName);
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return name;
    }

    private void maybeAppend(Map<Object, Object> report, boolean reportNulls, String name, Supplier<Object> supplier) {
        boolean isNullOrEmpty;
        Object value = supplier.get();
        boolean bl = isNullOrEmpty = value != null && !value.equals(Optional.empty());
        if (reportNulls || isNullOrEmpty) {
            report.put(SampleReportingFormat.plainLabel((String)name), value);
        }
    }
}

