/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.jqwik.api.JqwikException;

public class SourceOfRandomness {
    private static final Supplier<Random> RNG = ThreadLocalRandom::current;
    private static final ThreadLocal<Random> current = ThreadLocal.withInitial(SourceOfRandomness::newRandom);

    private SourceOfRandomness() {
    }

    public static String createRandomSeed() {
        return Long.toString(RNG.get().nextLong());
    }

    public static Random create(String seed) {
        try {
            Random random = SourceOfRandomness.newRandom(Long.parseLong(seed));
            current.set(random);
            return random;
        }
        catch (NumberFormatException nfe) {
            throw new JqwikException(String.format("[%s] is not a valid random seed.", seed));
        }
    }

    public static Random newRandom() {
        return new XORShiftRandom();
    }

    public static Random newRandom(long seed) {
        return new XORShiftRandom(seed);
    }

    public static Random current() {
        return current.get();
    }

    private static class XORShiftRandom
    extends Random {
        private long seed;

        private XORShiftRandom() {
            this(System.nanoTime());
        }

        private XORShiftRandom(long seed) {
            if (seed == 0L) {
                throw new IllegalArgumentException("0L is not an allowed seed value");
            }
            this.seed = seed;
        }

        @Override
        protected int next(int nbits) {
            long x = this.nextLong();
            return (int)(x &= (1L << nbits) - 1L);
        }

        @Override
        public long nextLong() {
            long x = this.seed;
            x ^= x << 21;
            x ^= x >>> 35;
            x ^= x << 4;
            this.seed = x;
            return x;
        }
    }
}

