/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.sessions;

import net.jqwik.api.FacadeLoader;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.8.0")
public class JqwikSession {
    public static synchronized void start() {
        JqwikSessionFacade.implementation.startSession();
    }

    public static boolean isActive() {
        return JqwikSessionFacade.implementation.isSessionOpen();
    }

    public static synchronized void finish() {
        JqwikSessionFacade.implementation.finishSession();
    }

    public static synchronized void finishTry() {
        JqwikSessionFacade.implementation.finishTry();
    }

    public static synchronized void run(Runnable runnable) {
        JqwikSessionFacade.implementation.runInSession(runnable);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class JqwikSessionFacade {
        private static final JqwikSessionFacade implementation = FacadeLoader.load(JqwikSessionFacade.class);

        public abstract void startSession();

        public abstract void finishSession();

        public abstract void finishTry();

        public abstract boolean isSessionOpen();

        public abstract void runInSession(Runnable var1);
    }

    @FunctionalInterface
    public static interface Runnable {
        public void run() throws Throwable;
    }
}

